/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.event;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rero.bridges.event.CodeSnippet;
import rero.bridges.event.EventChatListener;
import rero.util.ClientUtils;
import rero.util.StringUtils;
import sleep.runtime.ScriptEnvironment;

public class FilterChatListener
extends EventChatListener {
    protected ScriptEnvironment env;
    protected String[] filter;
    protected String event;
    protected CodeSnippet code;
    protected int isPublic;
    private static final Pattern filterPattern = Pattern.compile("(.*?) (.*?) (.*)");

    public FilterChatListener(ScriptEnvironment scriptEnvironment, String string, String string2, CodeSnippet codeSnippet) {
        this.env = scriptEnvironment;
        this.event = string.toUpperCase();
        if (this.event.equals("PUBLIC")) {
            this.isPublic = 1;
            this.event = "PRIVMSG";
        } else if (this.event.equals("PUBLIC_ACTION")) {
            this.isPublic = 1;
            this.event = "ACTION";
        } else if (this.event.equals("PRIVATE_ACTION")) {
            this.isPublic = 2;
            this.event = "ACTION";
        } else if (this.event.equals("MSG")) {
            this.isPublic = 2;
            this.event = "MSG";
        } else if (this.event.length() > 6 && this.event.substring(0, 5).equals("REPL_")) {
            this.isPublic = 0;
            this.event = this.event.substring(5, this.event.length());
        } else {
            this.isPublic = 0;
        }
        this.code = codeSnippet;
        this.filter = new String[3];
        string2 = this.env.evaluateExpression(string2) + "";
        Matcher matcher = filterPattern.matcher(string2.toUpperCase());
        if (matcher.matches()) {
            this.filter[0] = matcher.group(1);
            this.filter[1] = matcher.group(2);
            this.filter[2] = matcher.group(3);
            this.addListener(codeSnippet);
        } else {
            scriptEnvironment.getScriptInstance().fireWarning("Invalid format for event " + string + " filter: " + string2, codeSnippet.getLineNumber());
        }
    }

    private boolean isMatch(HashMap hashMap) {
        String string = (hashMap.get("$target") + "").toUpperCase();
        String string2 = (hashMap.get("$source") + "").toUpperCase();
        String string3 = (hashMap.get("$parms") + "").toUpperCase();
        if (string.equals("")) {
            string = "<none>";
        }
        if (string2.equals("")) {
            string = "<none>";
        }
        boolean bl = true;
        if (this.isPublic > 0 && ClientUtils.isChannel(string)) {
            bl = this.isPublic == 1;
        }
        return bl && StringUtils.iswm(this.filter[0], string2) && StringUtils.iswm(this.filter[1], string) && StringUtils.iswm(this.filter[2], string3);
    }

    public boolean isChatEvent(String string, HashMap hashMap) {
        if (!this.code.isValid()) {
            return false;
        }
        return string.toUpperCase().equals(this.event) && this.isMatch(hashMap);
    }
}

