/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.menu;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import rero.bridges.menu.CodeSnippet;
import rero.bridges.menu.MenuBridge;
import rero.bridges.menu.MenuBridgeParent;
import rero.bridges.menu.ScriptedPopupMenu;
import rero.script.ScriptCore;
import sleep.engine.Block;
import sleep.runtime.ScriptInstance;

public class ScriptedMenu
extends JMenu
implements MenuListener,
MenuBridgeParent {
    protected LinkedList code;

    public ScriptedMenu(ScriptInstance scriptInstance, String string, Block block) {
        if (string.indexOf(38) > -1) {
            this.setText(string.substring(0, string.indexOf(38)) + string.substring(string.indexOf(38) + 1, string.length()));
            this.setMnemonic(string.charAt(string.indexOf(38) + 1));
        } else {
            this.setText(string);
        }
        this.code = new LinkedList();
        this.installCode(scriptInstance, block);
        this.addMenuListener(this);
    }

    public JPopupMenu getScriptedPopupMenu() {
        return new ScriptedPopupMenu(this.code);
    }

    public void installCode(ScriptInstance scriptInstance, Block block) {
        this.code.add(new CodeSnippet(scriptInstance, block));
    }

    public boolean isValidCode() {
        Iterator iterator = this.code.iterator();
        while (iterator.hasNext()) {
            CodeSnippet codeSnippet = (CodeSnippet)iterator.next();
            if (codeSnippet.getOwner().isLoaded()) continue;
            iterator.remove();
        }
        return this.code.size() > 0;
    }

    public void menuSelected(MenuEvent menuEvent) {
        MenuBridge.SetParent(this);
        Iterator iterator = this.code.iterator();
        while (iterator.hasNext()) {
            CodeSnippet codeSnippet = (CodeSnippet)iterator.next();
            if (!codeSnippet.getOwner().isLoaded()) continue;
            ScriptCore.runCode(codeSnippet.getOwner(), codeSnippet.getBlock(), ScriptedPopupMenu.getMenuData());
        }
        MenuBridge.FinishParent();
    }

    public void menuDeselected(MenuEvent menuEvent) {
        this.removeAll();
    }

    public void menuCanceled(MenuEvent menuEvent) {
        this.removeAll();
    }
}

