/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.Stack;
import rero.client.Feature;
import rero.client.dcc.LocalInfo;
import rero.dcc.DataDCC;
import rero.dcc.GenericDCC;
import rero.dcc.ListenDCC;
import rero.dcc.ProtocolDCC;
import rero.dcc.Receive;
import rero.dcc.Send;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class DCCOperators
extends Feature
implements Loadable {
    protected DataDCC dccData;

    public void init() {
        this.dccData = (DataDCC)this.getCapabilities().getDataStructure("dcc");
        this.getCapabilities().getScriptCore().addBridge(this);
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getActiveConnections", new getActiveConnections());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getWaitingConnections", new getWaitingConnections());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getInactiveConnections", new getInactiveConnections());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getSpecificConnection", new getSpecificConnection());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getAllConnections", new getAllConnections());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getDCCConnection", new getDCCConnection());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getConnectionType", new getConnectionType());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getConnectionState", new getConnectionState());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getLocalPort", new getLocalPort());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getRemotePort", new getRemotePort());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getDCCAddress", new getConnectionAddress());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getDCCNickname", new getConnectionNickname());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getDCCIdleTime", new getIdleTime());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getDCCStartTime", new getStartTime());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getDCCTotalTime", new getTotalTime());
        scriptInstance.getScriptEnvironment().getEnvironment().put("-isdccopen", new isOpen());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&closeDCC", new closeDCC());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getFileSizeOffset", new B_getStartOffset());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getDCCFileName", new B_getFileName());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getDCCFilePath", new B_getFilePath());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getTransferRate", new B_getTransferRate());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getTimeRemaining", new B_getTimeRemaining());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getAcknowledgedSize", new S_getAcknowledgedSize());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getBytesSent", new S_getBytesSent());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getBytesReceived", new R_getBytesReceived());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getExpectedSize", new R_getExpectedSize());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&localip", new localip());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getNextPort", new getNextPort());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public static int getType(String string) {
        if ((string = string.toUpperCase()).equals("SEND")) {
            return 1;
        }
        if (string.equals("CHAT")) {
            return 3;
        }
        if (string.equals("RECEIVE")) {
            return 2;
        }
        return -1;
    }

    private static String getTypeString(int n) {
        if (n == 1) {
            return "SEND";
        }
        if (n == 3) {
            return "CHAT";
        }
        if (n == 2) {
            return "RECEIVE";
        }
        return "Unknown";
    }

    private static String getStateString(int n) {
        if (n == 402) {
            return "OPEN";
        }
        if (n == 403) {
            return "CLOSED";
        }
        if (n == 401) {
            return "WAIT";
        }
        return "Unknown";
    }

    private static int getState(String string) {
        if (string.equals("OPEN")) {
            return 402;
        }
        if (string.equals("CLOSED")) {
            return 403;
        }
        if (string.equals("WAIT")) {
            return 401;
        }
        return -1;
    }

    private static ProtocolDCC deriveImplementation(Object object) {
        if (object instanceof GenericDCC) {
            return ((GenericDCC)object).getImplementation();
        }
        if (object instanceof ProtocolDCC) {
            return (ProtocolDCC)object;
        }
        return null;
    }

    private class B_getFilePath
    implements Function {
        private B_getFilePath() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            ProtocolDCC protocolDCC = DCCOperators.deriveImplementation(BridgeUtilities.getObject(stack));
            if (protocolDCC instanceof Send) {
                return SleepUtils.getScalar(((Send)protocolDCC).getFile().getAbsolutePath());
            }
            if (protocolDCC instanceof Receive) {
                return SleepUtils.getScalar(((Receive)protocolDCC).getFile().getAbsolutePath());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class B_getFileName
    implements Function {
        private B_getFileName() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            ProtocolDCC protocolDCC = DCCOperators.deriveImplementation(BridgeUtilities.getObject(stack));
            if (protocolDCC instanceof Send) {
                return SleepUtils.getScalar(((Send)protocolDCC).getFile().getName());
            }
            if (protocolDCC instanceof Receive) {
                return SleepUtils.getScalar(((Receive)protocolDCC).getFile().getName());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class B_getTimeRemaining
    implements Function {
        private B_getTimeRemaining() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            ProtocolDCC protocolDCC = DCCOperators.deriveImplementation(BridgeUtilities.getObject(stack));
            if (protocolDCC instanceof Send) {
                return SleepUtils.getScalar(((Send)protocolDCC).getTimeRemaining());
            }
            if (protocolDCC instanceof Receive) {
                return SleepUtils.getScalar(((Receive)protocolDCC).getTimeRemaining());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class B_getTransferRate
    implements Function {
        private B_getTransferRate() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            ProtocolDCC protocolDCC = DCCOperators.deriveImplementation(BridgeUtilities.getObject(stack));
            if (protocolDCC instanceof Send) {
                return SleepUtils.getScalar(((Send)protocolDCC).getTransferRate());
            }
            if (protocolDCC instanceof Receive) {
                return SleepUtils.getScalar(((Receive)protocolDCC).getTransferRate());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class B_getStartOffset
    implements Function {
        private B_getStartOffset() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            ProtocolDCC protocolDCC = ((GenericDCC)BridgeUtilities.getObject(stack)).getImplementation();
            if (protocolDCC instanceof Send) {
                return SleepUtils.getScalar(((Send)protocolDCC).getStartOffset());
            }
            if (protocolDCC instanceof Receive) {
                return SleepUtils.getScalar(((Receive)protocolDCC).getStartOffset());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class R_getBytesReceived
    implements Function {
        private R_getBytesReceived() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Receive receive = (Receive)((GenericDCC)BridgeUtilities.getObject(stack)).getImplementation();
            return SleepUtils.getScalar(receive.getBytesReceived());
        }
    }

    private class R_getExpectedSize
    implements Function {
        private R_getExpectedSize() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Receive receive = (Receive)((GenericDCC)BridgeUtilities.getObject(stack)).getImplementation();
            return SleepUtils.getScalar(receive.getExpectedSize());
        }
    }

    private class S_getBytesSent
    implements Function {
        private S_getBytesSent() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Send send = (Send)((GenericDCC)BridgeUtilities.getObject(stack)).getImplementation();
            return SleepUtils.getScalar(send.getBytesSent());
        }
    }

    private class S_getAcknowledgedSize
    implements Function {
        private S_getAcknowledgedSize() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Send send = (Send)((GenericDCC)BridgeUtilities.getObject(stack)).getImplementation();
            return SleepUtils.getScalar(send.getAcknowledgedSize());
        }
    }

    private class isOpen
    implements Predicate {
        private isOpen() {
        }

        public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
            GenericDCC genericDCC = (GenericDCC)BridgeUtilities.getObject(stack);
            return genericDCC.getState() == 402;
        }
    }

    private class getTotalTime
    implements Function {
        private getTotalTime() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GenericDCC genericDCC = (GenericDCC)BridgeUtilities.getObject(stack);
            return SleepUtils.getScalar(genericDCC.getImplementation().getTotalTime());
        }
    }

    private class getStartTime
    implements Function {
        private getStartTime() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GenericDCC genericDCC = (GenericDCC)BridgeUtilities.getObject(stack);
            return SleepUtils.getScalar(genericDCC.getImplementation().getStartTime());
        }
    }

    private class getIdleTime
    implements Function {
        private getIdleTime() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GenericDCC genericDCC = (GenericDCC)BridgeUtilities.getObject(stack);
            return SleepUtils.getScalar(genericDCC.getImplementation().getIdleTime());
        }
    }

    private class getConnectionNickname
    implements Function {
        private getConnectionNickname() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GenericDCC genericDCC = (GenericDCC)BridgeUtilities.getObject(stack);
            return SleepUtils.getScalar(genericDCC.getImplementation().getNickname());
        }
    }

    private class getConnectionAddress
    implements Function {
        private getConnectionAddress() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GenericDCC genericDCC = (GenericDCC)BridgeUtilities.getObject(stack);
            return SleepUtils.getScalar(genericDCC.getImplementation().getRemoteAddress());
        }
    }

    private class getRemotePort
    implements Function {
        private getRemotePort() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GenericDCC genericDCC = (GenericDCC)BridgeUtilities.getObject(stack);
            return SleepUtils.getScalar(genericDCC.getImplementation().getPort());
        }
    }

    private class getLocalPort
    implements Function {
        private getLocalPort() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GenericDCC genericDCC = (GenericDCC)BridgeUtilities.getObject(stack);
            return SleepUtils.getScalar(genericDCC.getImplementation().getLocalPort());
        }
    }

    private class getConnectionState
    implements Function {
        private getConnectionState() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GenericDCC genericDCC = (GenericDCC)BridgeUtilities.getObject(stack);
            return SleepUtils.getScalar(DCCOperators.getStateString(genericDCC.getState()));
        }
    }

    private class getConnectionType
    implements Function {
        private getConnectionType() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GenericDCC genericDCC = (GenericDCC)BridgeUtilities.getObject(stack);
            return SleepUtils.getScalar(DCCOperators.getTypeString(genericDCC.getTypeOfDCC()));
        }
    }

    private class getAllConnections
    implements Function {
        private getAllConnections() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getArrayWrapper(DCCOperators.this.dccData.getAllConnections());
        }
    }

    private class getInactiveConnections
    implements Function {
        private getInactiveConnections() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getArrayWrapper(DCCOperators.this.dccData.getConnections(-1, 403));
        }
    }

    private class getWaitingConnections
    implements Function {
        private getWaitingConnections() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getArrayWrapper(DCCOperators.this.dccData.getConnections(-1, 401));
        }
    }

    private class closeDCC
    implements Function {
        private closeDCC() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            GenericDCC genericDCC = (GenericDCC)BridgeUtilities.getObject(stack);
            genericDCC.getImplementation().close();
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getDCCConnection
    implements Function {
        private getDCCConnection() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            return SleepUtils.getScalar(DCCOperators.this.dccData.getConnectionFromHash(string2));
        }
    }

    private class getSpecificConnection
    implements Function {
        private getSpecificConnection() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            String string3 = BridgeUtilities.getString(stack, "Unknown");
            return SleepUtils.getScalar(DCCOperators.this.dccData.getSpecificConnection(string2, DCCOperators.getType(string3)));
        }
    }

    private class getActiveConnections
    implements Function {
        private getActiveConnections() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getArrayWrapper(DCCOperators.this.dccData.getConnections(-1, 402));
        }
    }

    private static class getNextPort
    implements Function {
        private getNextPort() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(ListenDCC.getNextPort());
        }
    }

    private class localip
    implements Function {
        private localip() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            LocalInfo localInfo = (LocalInfo)DCCOperators.this.getCapabilities().getDataStructure("localInfo");
            return SleepUtils.getScalar(localInfo.localip());
        }
    }
}

