/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.Stack;
import rero.client.Feature;
import rero.client.notify.NotifyData;
import rero.client.notify.NotifyUser;
import rero.ircfw.InternalDataList;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class NotifyOperators
extends Feature
implements Predicate,
Function,
Loadable {
    protected InternalDataList data;
    protected NotifyData notify;

    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        this.notify = (NotifyData)this.getCapabilities().getDataStructure("notify");
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        String[] stringArray = new String[]{"-isnotify", "-issignedon", "-issignedoff", "&getNotifyUsers", "&getSignedOnUsers", "&getSignedOffUsers", "&onlineFor", "&getAddressFromNotify"};
        for (int i = 0; i < stringArray.length; ++i) {
            scriptInstance.getScriptEnvironment().getEnvironment().put(stringArray[i], this);
        }
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&onlineFor")) {
            if (stack.size() != 1) {
                return SleepUtils.getEmptyScalar();
            }
            NotifyUser notifyUser = this.notify.getUserInfo(((Object)((Scalar)stack.pop()).getValue()).toString());
            return SleepUtils.getScalar(notifyUser.getTimeOnline());
        }
        if (string.equals("&getAddressFromNotify")) {
            if (stack.size() != 1) {
                return SleepUtils.getEmptyScalar();
            }
            String string2 = stack.pop().toString();
            NotifyUser notifyUser = this.notify.getUserInfo(string2);
            if (notifyUser == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(notifyUser.getAddress());
        }
        if (string.equals("&getNotifyUsers")) {
            return SleepUtils.getArrayWrapper(this.notify.getNotifyUsers());
        }
        if (string.equals("&getSignedOnUsers")) {
            return SleepUtils.getArrayWrapper(this.notify.getSignedOnUsers());
        }
        if (string.equals("&getSignedOffUsers")) {
            return SleepUtils.getArrayWrapper(this.notify.getSignedOffUsers());
        }
        return null;
    }

    public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
        if (stack.size() != 1) {
            return false;
        }
        String string2 = ((Object)((Scalar)stack.pop()).getValue()).toString();
        NotifyUser notifyUser = this.notify.getUserInfo(string2);
        if (notifyUser == null) {
            return false;
        }
        if (string.equals("-signedon")) {
            return notifyUser.isSignedOn();
        }
        if (string.equals("-signedoff")) {
            return !notifyUser.isSignedOn();
        }
        return false;
    }
}

