/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.Stack;
import rero.client.Feature;
import rero.util.TokenizedString;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class TokenOperators
extends Feature
implements Loadable {
    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        scriptInstance.getScriptEnvironment().getEnvironment().put("&tokenize", new tokenize());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getToken", new getToken());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getTokenFrom", new getTokenFrom());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getTokenTo", new getTokenTo());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getTokenRange", new getTokenRange());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getAllTokens", new getAllTokens());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getTotalTokens", new getTotalTokens());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&findToken", new findToken());
        scriptInstance.getScriptEnvironment().getEnvironment().put("istoken", new isToken());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    private static TokenizedString extractTokens(Stack stack) {
        return (TokenizedString)BridgeUtilities.getObject(stack);
    }

    private static class isToken
    implements Predicate {
        private isToken() {
        }

        public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
            TokenizedString tokenizedString = TokenOperators.extractTokens(stack);
            String string2 = BridgeUtilities.getString(stack, "");
            return tokenizedString.isToken(string2);
        }
    }

    private static class getAllTokens
    implements Function {
        private getAllTokens() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            TokenizedString tokenizedString = TokenOperators.extractTokens(stack);
            Scalar scalar = SleepUtils.getArrayScalar();
            for (int i = 0; i < tokenizedString.getTotalTokens(); ++i) {
                scalar.getArray().push(SleepUtils.getScalar(tokenizedString.getToken(i)));
            }
            return scalar;
        }
    }

    private static class findToken
    implements Function {
        private findToken() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            TokenizedString tokenizedString = TokenOperators.extractTokens(stack);
            String string2 = BridgeUtilities.getString(stack, "");
            return SleepUtils.getScalar(tokenizedString.findToken(string2));
        }
    }

    private static class getTotalTokens
    implements Function {
        private getTotalTokens() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            TokenizedString tokenizedString = TokenOperators.extractTokens(stack);
            return SleepUtils.getScalar(tokenizedString.getTotalTokens());
        }
    }

    private static class getTokenRange
    implements Function {
        private getTokenRange() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            TokenizedString tokenizedString = TokenOperators.extractTokens(stack);
            int n = BridgeUtilities.getInt(stack, 0);
            int n2 = BridgeUtilities.getInt(stack, 0);
            return SleepUtils.getScalar(tokenizedString.getTokenRange(n, n2));
        }
    }

    private static class getTokenTo
    implements Function {
        private getTokenTo() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            TokenizedString tokenizedString = TokenOperators.extractTokens(stack);
            int n = BridgeUtilities.getInt(stack, 0);
            return SleepUtils.getScalar(tokenizedString.getTokenTo(n));
        }
    }

    private static class getTokenFrom
    implements Function {
        private getTokenFrom() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            TokenizedString tokenizedString = TokenOperators.extractTokens(stack);
            int n = BridgeUtilities.getInt(stack, 0);
            return SleepUtils.getScalar(tokenizedString.getTokenFrom(n));
        }
    }

    private static class getToken
    implements Function {
        private getToken() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            TokenizedString tokenizedString = TokenOperators.extractTokens(stack);
            int n = BridgeUtilities.getInt(stack, 0);
            return SleepUtils.getScalar(tokenizedString.getToken(n));
        }
    }

    private static class tokenize
    implements Function {
        private tokenize() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            String string3 = BridgeUtilities.getString(stack, " ");
            return SleepUtils.getScalar(new TokenizedString(string2, string3));
        }
    }
}

