/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import rero.client.Feature;
import rero.config.ClientState;
import rero.config.StringList;
import rero.util.ClientUtils;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import text.TextSource;

public class UtilOperators
extends Feature
implements Loadable {
    private static HashMap bridges = new HashMap();

    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        scriptInstance.getScriptEnvironment().getEnvironment().put("&formatBytes", new formatBytes());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&duration", new duration());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&formatTime", new formatTime());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&formatTime2", new formatTime2());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&formatTime3", new formatTime3());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&formatDecimal", new formatDecimal());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&longip", new longip());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&ctime", new ctime());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&timeDateStamp", new timeDateStamp());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&timeStamp", new timeStamp());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&showInputDialog", new showInputDialog());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&showFileDialog", new showChooserDialog(0));
        scriptInstance.getScriptEnvironment().getEnvironment().put("&showDirectoryDialog", new showChooserDialog(1));
        scriptInstance.getScriptEnvironment().getEnvironment().put("&setMappedColor", new setMappedColor());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getMappedColor", new getMappedColor());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&saveColorMap", new saveColorMap());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&generateThemeScript", new generateTheme());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&loadFont", new loadFont());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getScriptPath", new getScriptPath());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&getScriptResource", new getScriptResource());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&strip", new strip());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&strwidth", new strwidth());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&versionString", new versionString());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&exit", new exit());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&use", new f2_use());
        scriptInstance.getScriptEnvironment().getEnvironment().put("-ischannel", new isChannel());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&groupNicks", new groupUsers());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&fileCompleteAll", new fileCompleteAll());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&buildCP437String", new buildString());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    private static File _getScriptPath(String string) {
        StringList stringList = ClientState.getClientState().getStringList("script.files");
        Iterator iterator = stringList.getList().iterator();
        while (iterator.hasNext()) {
            File file = new File(iterator.next().toString());
            if (!file.getName().equals(string) && !file.getAbsolutePath().equals(string)) continue;
            return file.getParentFile();
        }
        return null;
    }

    private static class duration
    implements Function {
        private duration() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            long l = BridgeUtilities.getLong(stack, 0L);
            StringBuffer stringBuffer = new StringBuffer();
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            l4 = l / 86400L;
            l3 = l / 3600L % 24L;
            l2 = l / 60L % 60L;
            l %= 60L;
            if (l4 > 0L) {
                stringBuffer.append(l4);
                if (l4 == 1L) {
                    stringBuffer.append("day, ");
                } else {
                    stringBuffer.append("days, ");
                }
            }
            if (l3 > 0L) {
                stringBuffer.append(l3);
                if (l3 == 1L) {
                    stringBuffer.append("hour, ");
                } else {
                    stringBuffer.append("hours, ");
                }
            }
            if (l2 > 0L) {
                stringBuffer.append(l2);
                if (l2 == 1L) {
                    stringBuffer.append("minute, ");
                } else {
                    stringBuffer.append("minutes, ");
                }
            }
            stringBuffer.append(l);
            if (l == 1L) {
                stringBuffer.append("second");
            } else {
                stringBuffer.append("seconds");
            }
            return SleepUtils.getScalar(stringBuffer.toString());
        }
    }

    private static class isChannel
    implements Predicate {
        private isChannel() {
        }

        public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
            return ClientUtils.isChannel(BridgeUtilities.getString(stack, " "));
        }
    }

    private static class groupUsers
    implements Function {
        private groupUsers() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String[] stringArray;
            ScalarArray scalarArray = BridgeUtilities.getArray(stack);
            int n = BridgeUtilities.getInt(stack, 4);
            Scalar scalar = SleepUtils.getArrayScalar();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 1;
            Iterator iterator = scalarArray.scalarIterator();
            while (iterator.hasNext()) {
                stringArray = iterator.next().toString();
                stringBuffer.append((String)stringArray);
                if (n2 % n == 0 && n2 > 1) {
                    stringBuffer.append("=");
                } else {
                    stringBuffer.append(",");
                }
                ++n2;
            }
            if (stringBuffer.toString().length() > 1) {
                stringArray = stringBuffer.toString().substring(0, stringBuffer.toString().length() - 1).split("=");
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    scalar.getArray().push(SleepUtils.getScalar(stringArray[n2]));
                }
            }
            return scalar;
        }
    }

    private static class fileCompleteAll
    implements Function {
        private fileCompleteAll() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar = SleepUtils.getArrayScalar();
            Iterator iterator = ClientUtils.fileCompleteAll(BridgeUtilities.getString(stack, "")).iterator();
            while (iterator.hasNext()) {
                scalar.getArray().push(SleepUtils.getScalar(iterator.next().toString()));
            }
            return scalar;
        }
    }

    private static class saveColorMap
    implements Function {
        private saveColorMap() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            TextSource.saveColorMap();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class getMappedColor
    implements Function {
        private getMappedColor() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            int n = BridgeUtilities.getInt(stack);
            if (n < TextSource.colorTable.length && n > 0) {
                return SleepUtils.getScalar(TextSource.colorTable[n].getRGB());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class setMappedColor
    implements Function {
        private setMappedColor() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            int n = BridgeUtilities.getInt(stack);
            String string2 = stack.pop().toString();
            if (n < TextSource.colorTable.length && n >= 0) {
                TextSource.colorTable[n] = Color.decode(string2);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class timeStamp
    implements Function {
        private timeStamp() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(ClientUtils.TimeStamp());
        }
    }

    private static class formatDecimal
    implements Function {
        private formatDecimal() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            long l = BridgeUtilities.getLong(stack);
            return SleepUtils.getScalar(ClientUtils.formatLongAsDecimal(l));
        }
    }

    private static class ctime
    implements Function {
        private ctime() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(ClientUtils.ctime());
        }
    }

    private class showChooserDialog
    implements Function {
        private int dirChooser;
        private JFileChooser chooser = null;

        public showChooserDialog(int n) {
            this.dirChooser = n;
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            int n;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
            }
            this.chooser.setFileSelectionMode(this.dirChooser);
            String string2 = "Select File";
            if (!stack.isEmpty()) {
                string2 = stack.pop().toString();
            }
            this.chooser.setDialogTitle(string2);
            if (!stack.isEmpty()) {
                this.chooser.setCurrentDirectory(new File(stack.pop().toString()));
            }
            if (!stack.isEmpty()) {
                this.chooser.setApproveButtonText(stack.pop().toString());
            }
            if ((n = this.chooser.showOpenDialog(UtilOperators.this.getCapabilities().getGlobalCapabilities().getFrame())) == 0) {
                return SleepUtils.getScalar(this.chooser.getSelectedFile().getAbsolutePath());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class showInputDialog
    implements Function {
        private showInputDialog() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2;
            String string3 = "Your answer?";
            if (!stack.isEmpty()) {
                string3 = stack.pop().toString();
            }
            String string4 = "Input Requested";
            if (!stack.isEmpty()) {
                string4 = stack.pop().toString();
            }
            if ((string2 = JOptionPane.showInputDialog(UtilOperators.this.getCapabilities().getGlobalCapabilities().getFrame(), string3, string4, 3)) == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(string2);
        }
    }

    private class exit
    implements Function {
        private exit() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            UtilOperators.this.getCapabilities().getGlobalCapabilities().QuitClient();
            return null;
        }
    }

    private static class longip
    implements Function {
        private longip() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            return SleepUtils.getScalar(ClientUtils.longip(string2));
        }
    }

    private static class timeDateStamp
    implements Function {
        private timeDateStamp() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            long l = BridgeUtilities.getLong(stack);
            return SleepUtils.getScalar(ClientUtils.TimeDateStamp(l));
        }
    }

    private static class formatTime3
    implements Function {
        private formatTime3() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            long l = BridgeUtilities.getLong(stack);
            return SleepUtils.getScalar(ClientUtils.formatTime3(l));
        }
    }

    private static class formatTime2
    implements Function {
        private formatTime2() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            long l = BridgeUtilities.getLong(stack);
            return SleepUtils.getScalar(ClientUtils.formatTime2(l));
        }
    }

    private static class formatTime
    implements Function {
        private formatTime() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            long l = BridgeUtilities.getLong(stack);
            return SleepUtils.getScalar(ClientUtils.formatTime(l));
        }
    }

    private static class formatBytes
    implements Function {
        private formatBytes() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            long l = BridgeUtilities.getLong(stack);
            return SleepUtils.getScalar(ClientUtils.formatBytes(l));
        }
    }

    private static class loadFont
    implements Function {
        private loadFont() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            try {
                Font font = Font.createFont(0, ClientState.getClientState().getResourceAsStream(string2));
                return SleepUtils.getScalar(ClientUtils.encodeFont(font));
            }
            catch (Exception exception) {
                scriptInstance.getScriptEnvironment().flagError(exception.getMessage());
                return SleepUtils.getEmptyScalar();
            }
        }
    }

    private static class versionString
    implements Function {
        private versionString() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(ClientState.getClientState().getString("version.string", "08.07.08"));
        }
    }

    private static class generateTheme
    implements Function {
        private generateTheme() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            if (stack.size() >= 1) {
                ClientUtils.generateThemeScript(stack.pop().toString());
            } else {
                ClientUtils.generateThemeScript(null);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class strip
    implements Function {
        private strip() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(ClientUtils.strip(BridgeUtilities.getString(stack, "")));
        }
    }

    private static class getScriptResource
    implements Function {
        private getScriptResource() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            if (stack.size() < 2) {
                return SleepUtils.getEmptyScalar();
            }
            File file = UtilOperators._getScriptPath(stack.pop().toString());
            while (!stack.isEmpty()) {
                file = new File(file, stack.pop().toString());
            }
            return SleepUtils.getScalar(file.getAbsolutePath());
        }
    }

    private static class getScriptPath
    implements Function {
        private getScriptPath() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            if (stack.size() < 1) {
                return SleepUtils.getEmptyScalar();
            }
            File file = UtilOperators._getScriptPath(stack.pop().toString());
            if (file == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(file.getAbsolutePath());
        }
    }

    private static class buildString
    implements Function {
        private buildString() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            return SleepUtils.getScalar(ClientUtils.BuildCP437String(string2));
        }
    }

    private static class f2_use
    implements Function {
        private f2_use() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Serializable serializable;
            String string2;
            File file;
            if (stack.size() == 2) {
                file = BridgeUtilities.getFile(stack, scriptInstance);
                string2 = BridgeUtilities.getString(stack, "");
            } else {
                serializable = BridgeUtilities.getFile(stack, scriptInstance);
                file = ((File)serializable).getParentFile();
                string2 = ((File)serializable).getName();
            }
            try {
                Object object;
                if (file != null) {
                    object = new URLClassLoader(new URL[]{file.toURL()});
                    serializable = Class.forName(string2, true, (ClassLoader)object);
                } else {
                    serializable = Class.forName(string2);
                }
                if (bridges.get(((Class)serializable).toString()) == null) {
                    object = (Loadable)((Class)serializable).newInstance();
                    bridges.put(((Class)serializable).toString(), object);
                } else {
                    object = (Loadable)bridges.get(((Class)serializable).toString());
                }
                object.scriptLoaded(scriptInstance);
            }
            catch (Exception exception) {
                scriptInstance.getScriptEnvironment().flagError(exception.toString());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class strwidth
    implements Function {
        private strwidth() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(TextSource.fontMetrics.stringWidth(BridgeUtilities.getString(stack, "")));
        }
    }
}

