/*
 * Decompiled with CFR 0.152.
 */
package rero.client.output;

import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import rero.client.Feature;
import rero.client.output.OutputCapabilities;
import rero.dcc.Chat;
import rero.dcc.DataDCC;
import rero.ircfw.InternalDataList;
import rero.net.SocketConnection;
import rero.util.ClientUtils;

public class ChatCapabilities
extends Feature {
    protected SocketConnection sock;
    protected OutputCapabilities output;
    protected DataDCC dccData;

    public void init() {
        this.sock = this.getCapabilities().getSocketConnection();
        this.output = this.getCapabilities().getOutputCapabilities();
        this.dccData = (DataDCC)this.getCapabilities().getDataStructure("dcc");
    }

    public void sendMessage(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string.charAt(0) == '=') {
            String string3 = string.substring(1, string.length());
            Chat chat = (Chat)this.dccData.getSpecificConnection(string3, 3);
            if (chat == null) {
                hashMap.put("$target", string3);
                hashMap.put("$parms", string2);
                hashMap.put("$data", string3 + " " + string2);
                this.output.fireSetTarget(hashMap, string, "SEND_CHAT_ERROR");
                return;
            }
            chat.sendln(string2);
        } else {
            int n = this.computeMaxMessageLength(string);
            if (string2.length() > n) {
                String[] stringArray = ChatCapabilities.wrapMessageToStringsArray(string2, n);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    this.sock.println("PRIVMSG " + string + " :" + string4);
                }
            } else {
                this.sock.println("PRIVMSG " + string + " :" + string2);
            }
        }
        if (string.charAt(0) == '=') {
            hashMap.put("$target", string.substring(1, string.length()));
            hashMap.put("$parms", string2);
            hashMap.put("$data", string.substring(1, string.length()) + " " + string2);
            this.output.fireSetTarget(hashMap, string, "SEND_CHAT");
        } else if (ClientUtils.isChannel(string)) {
            hashMap.put("$target", string);
            hashMap.put("$channel", string);
            hashMap.put("$parms", string2);
            hashMap.put("$data", string + " " + string2);
            this.output.fireSetTarget(hashMap, string, this.output.chooseSet(string, "SEND_TEXT", "SEND_TEXT_INACTIVE"));
        } else {
            hashMap.put("$target", string);
            hashMap.put("$parms", string2);
            hashMap.put("$data", string + " " + string2);
            this.output.fireSetQuery(hashMap, string, string, "SEND_MSG");
        }
    }

    private int computeMaxMessageLength(String string) {
        InternalDataList internalDataList = (InternalDataList)this.output.getCapabilities().getDataStructure("clientInformation");
        String string2 = internalDataList.getMyUser().getFullAddress();
        int n = 512;
        n -= 14;
        n -= string2.length();
        return n -= string.length();
    }

    public void sendNotice(String string, String string2) {
        this.sock.println("NOTICE " + string + " :" + string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("$target", string);
        hashMap.put("$parms", string2);
        hashMap.put("$data", string + " " + string2);
        this.output.fireSetConfused(hashMap, string, "notice", "SEND_NOTICE");
    }

    public void sendAction(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string.charAt(0) == '=') {
            hashMap.put("$target", string.substring(1));
            hashMap.put("$parms", string2);
            hashMap.put("$data", string.substring(1) + " " + string2);
            this.output.fireSetTarget(hashMap, string, this.output.chooseSet(string, "SEND_ACTION", "SEND_ACTION_INACTIVE"));
        } else if (ClientUtils.isChannel(string)) {
            hashMap.put("$target", string);
            hashMap.put("$channel", string);
            hashMap.put("$parms", string2);
            hashMap.put("$data", string + " " + string2);
            this.output.fireSetTarget(hashMap, string, this.output.chooseSet(string, "SEND_ACTION", "SEND_ACTION_INACTIVE"));
        } else {
            hashMap.put("$target", string);
            hashMap.put("$parms", string2);
            hashMap.put("$data", string + " " + string2);
            this.output.fireSetTarget(hashMap, string, "SEND_ACTION");
        }
        if (string.charAt(0) == '=') {
            Chat chat = (Chat)this.dccData.getSpecificConnection(string.substring(1), 3);
            if (chat == null) {
                this.output.fireSetTarget(hashMap, string, "SEND_CHAT_ERROR");
                return;
            }
            chat.sendln("\u0001ACTION " + string2 + '\u0001');
        } else {
            this.sock.println("PRIVMSG " + string + " :" + '\u0001' + "ACTION " + string2 + '\u0001');
        }
    }

    public void sendRequest(String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("$target", string);
        hashMap.put("$parms", string3);
        hashMap.put("$type", string2);
        hashMap.put("$data", string + " " + string2 + " " + string3);
        if (string2.equals("PING") && string3.equals("")) {
            string3 = System.currentTimeMillis() + "";
        }
        this.output.fireSetConfused(hashMap, string, "reply", "SEND_CTCP");
        if (string3.length() > 0) {
            this.sock.println("PRIVMSG " + string + " :" + '\u0001' + string2.toUpperCase() + " " + string3 + '\u0001');
        } else {
            this.sock.println("PRIVMSG " + string + " :" + '\u0001' + string2.toUpperCase() + '\u0001');
        }
    }

    public void sendReply(String string, String string2, String string3) {
        this.sock.println("NOTICE " + string + " :" + '\u0001' + string2.toUpperCase() + " " + string3 + '\u0001');
    }

    public static String[] wrapMessageToStringsArray(String string, int n) {
        String string2 = ChatCapabilities.wrapText(string, "\n", n);
        return string2.split("\n");
    }

    public static String wrapText(String string, String string2, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string3 = stringTokenizer.nextToken();
                if (string3.length() > n) {
                    string3 = ChatCapabilities.wrapLine(string3, string2, n);
                }
                stringBuffer.append(string3);
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        return stringBuffer.toString();
    }

    protected static String wrapLine(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.length() > n) {
            int n2 = string.lastIndexOf(32, n);
            if (n2 >= 0) {
                stringBuffer.append(string.substring(0, n2));
                stringBuffer.append(string2);
                string = string.substring(n2 + 1);
                continue;
            }
            n2 = n;
            stringBuffer.append(string.substring(0, n2));
            stringBuffer.append(string2);
            string = string.substring(n2);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

