/*
 * Decompiled with CFR 0.152.
 */
package rero.client.output;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import rero.bridges.set.SetEnvironment;
import rero.client.Feature;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.UICapabilities;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import rero.util.ClientUtils;

public class OutputCapabilities
extends Feature
implements ClientStateListener {
    protected SetEnvironment sets;
    protected UICapabilities gui;
    protected InternalDataList data;
    protected boolean doTimestamp;

    public void init() {
        this.sets = (SetEnvironment)this.getCapabilities().getDataStructure("setBridge");
        this.gui = this.getCapabilities().getUserInterface();
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        this.doTimestamp = ClientState.getClientState().isOption("option.timestamp", false);
        ClientState.getClientState().addClientStateListener("option.timestamp", this);
    }

    public void propertyChanged(String string, String string2) {
        this.doTimestamp = ClientState.getClientState().isOption("option.timestamp", false);
    }

    public void cycleQuery() {
        Channel channel;
        Set set = this.data.getMyUser().getChannels();
        boolean bl = false;
        if (this.gui.getQuery().length() == 0) {
            bl = true;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            channel = (Channel)iterator.next();
            if (bl && !this.gui.isActive(channel.getName())) {
                this.gui.setQuery(channel.getName());
                return;
            }
            if (!channel.getName().equals(this.gui.getQuery())) continue;
            bl = true;
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            channel = (Channel)iterator.next();
            if (this.gui.isActive(channel.getName())) continue;
            this.gui.setQuery(channel.getName());
            return;
        }
        this.gui.setQuery("");
    }

    public void fireSetActive(HashMap hashMap, String string) {
        this.gui.printActive(this.getSet(hashMap, string));
    }

    public void fireSetQuery(HashMap hashMap, String string, String string2, String string3) {
        if (string2.charAt(0) == '@' || string2.charAt(0) == '+' || string2.charAt(0) == '%') {
            string2 = string2.substring(1, string2.length());
        }
        boolean bl = ClientState.getClientState().isOption("active.query", true);
        if (ClientUtils.isChannel(string2)) {
            this.fireSetTarget(hashMap, string2, string3);
        } else if (this.getCapabilities().getUserInterface().isWindow(string)) {
            this.fireSetTarget(hashMap, string, string3);
        } else if (bl) {
            this.fireSetActive(hashMap, string3);
        } else {
            this.fireSetStatus(hashMap, string3);
        }
    }

    public void fireSetConfused(HashMap hashMap, String string, String string2, String string3) {
        if (string != null && string.length() > 0 && (string.charAt(0) == '@' || string.charAt(0) == '+' || string.charAt(0) == '%')) {
            string = string.substring(1, string.length());
        }
        boolean bl = ClientState.getClientState().isOption("active." + string2, true);
        if (string != null && this.getCapabilities().getUserInterface().isWindow(string)) {
            this.fireSetTarget(hashMap, string, string3);
        } else if (bl) {
            this.fireSetActive(hashMap, string3);
        } else {
            this.fireSetStatus(hashMap, string3);
        }
    }

    public void fireSetOption(HashMap hashMap, String string, String string2) {
        this.gui.printStatus(this.getSet(hashMap, string2));
    }

    public void fireSetTarget(HashMap hashMap, String string, String string2) {
        this.gui.printNormal(string, this.getSet(hashMap, string2));
    }

    public void fireSetAllDeadTarget(HashMap hashMap, String string, String string2) {
        Set set = this.data.getChannelsFromPriorLife(string);
        this.gui.printToTargets(set, this.getSet(hashMap, string2), false);
    }

    public void fireSetAllTarget(HashMap hashMap, String string, String string2) {
        this.echoToTarget(string, this.getSet(hashMap, string2), false);
    }

    public void fireSetAllTarget2(HashMap hashMap, String string, String string2) {
        this.echoToTarget(string, this.getSet(hashMap, string2), true);
    }

    public void fireSetStatus(HashMap hashMap, String string) {
        this.gui.printStatus(this.getSet(hashMap, string));
    }

    public void fireSetAll(HashMap hashMap, String string) {
        this.gui.printAll(this.getSet(hashMap, string));
    }

    public String chooseSet(String string, String string2, String string3) {
        if (this.gui.isActive(string)) {
            return string2;
        }
        return string3;
    }

    public String getSet(HashMap hashMap, String string) {
        if (this.sets.isSet(string)) {
            String string2 = this.sets.parseSet(string, hashMap);
            if (string2 == null || string2.equals("")) {
                return null;
            }
            if (this.doTimestamp && this.sets.isTimeStamped(string) && this.sets.isSet("TIMESTAMP")) {
                return this.sets.parseSet("TIMESTAMP", hashMap) + string2;
            }
            return string2;
        }
        return null;
    }

    public String parseSet(HashMap hashMap, String string) {
        return this.sets.parseSet(string, hashMap);
    }

    public boolean isSet(String string) {
        return this.sets.isSet(string);
    }

    public void echoToTarget(String string, String string2, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.data.getUser(string).getChannels().iterator();
        while (iterator.hasNext()) {
            Channel channel = (Channel)iterator.next();
            hashSet.add(channel.getName());
        }
        this.gui.printToTargets(hashSet, string2, bl);
    }

    public void echo(String string, String[] stringArray, double d) {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0].length() * stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        this.gui.printChunk(string, stringBuffer.toString(), stringArray, d);
    }
}

