/*
 * Decompiled with CFR 0.152.
 */
package rero.client.script;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedMap;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rero.client.Feature;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.config.StringList;
import rero.util.ClientUtils;
import sleep.error.RuntimeWarningWatcher;
import sleep.error.ScriptWarning;
import sleep.error.SyntaxError;
import sleep.error.YourCodeSucksException;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;

public class ScriptManager
extends Feature
implements ClientStateListener,
RuntimeWarningWatcher {
    protected ScriptLoader loader;
    protected Hashtable environment;
    protected boolean lock = false;
    private static boolean SILENT = false;
    private static boolean lame = true;
    private static final Pattern ENCODING_IN_FILE = Pattern.compile(".*\\.(.*?)\\..*$");
    private static final Pattern ENCODING_IN_EXTENSION = Pattern.compile(".*\\.(.*)$");
    private static SortedMap charsets = null;

    public void init() {
        this.loader = (ScriptLoader)this.getCapabilities().getDataStructure("scriptLoader");
        this.environment = (Hashtable)this.getCapabilities().getDataStructure("sharedEnvironment");
        ClientState.getClientState().addClientStateListener("script.files", this);
    }

    public void storeDataStructures(WeakHashMap weakHashMap) {
        weakHashMap.put("scriptManager", this);
    }

    public void hashScripts() {
        String string;
        if (this.lock) {
            return;
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(ClientState.getClientState().getStringList("script.files").getList());
        Set set = this.loader.getScriptsToLoad(linkedHashSet);
        Set set2 = this.loader.getScriptsToUnload(linkedHashSet);
        set.remove("menus");
        set.remove("default");
        set.remove("lame");
        set2.remove("menus");
        set2.remove("lame");
        set2.remove("default");
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.loader.unloadScript(string);
            if (!ClientState.getClientState().isOption("script.verboseLoad", true)) continue;
            this.getCapabilities().getUserInterface().printStatus("Successfully unloaded script " + string);
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (this.loader.isLoaded(string)) continue;
            this.internalScriptLoad(string);
        }
    }

    public void loadTheme(String string) {
        if (new File(string = ClientUtils.getFile(string).getAbsolutePath()).exists()) {
            this.internalScriptLoad(string);
            this.loader.unloadScript(string);
        } else {
            this.getCapabilities().getUserInterface().printStatus("Error loading script: " + new File(string).getAbsolutePath() + " does not exist");
        }
    }

    public void addScript(String string) {
        if (new File(string = ClientUtils.getFile(string).getAbsolutePath()).exists()) {
            StringList stringList = ClientState.getClientState().getStringList("script.files");
            String string2 = ClientUtils.getFile(string).getAbsolutePath();
            if (!stringList.getList().contains(string2)) {
                stringList.add(string2);
                stringList.save();
                ClientState.getClientState().sync();
            } else {
                this.getCapabilities().getUserInterface().printStatus("Script file " + string2 + " is already loaded.  Grabbing a beer instead");
            }
        } else {
            this.getCapabilities().getUserInterface().printStatus("Error loading script: " + new File(string).getAbsolutePath() + " does not exist");
        }
    }

    public void evalScript(String string) {
        try {
            this.getCapabilities().getUserInterface().printActive(((ScriptInstance)this.loader.getScripts().getFirst()).getScriptEnvironment().evaluateExpression(string).toString());
        }
        catch (YourCodeSucksException yourCodeSucksException) {
            this.formatCodeException("/eval input", yourCodeSucksException);
        }
    }

    public void setDebug(String string, String string2) {
        Iterator iterator = this.findScripts(string, ClientState.getClientState().getStringList("script.files").getList()).iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            this.setDebugReal(string3, string2);
        }
    }

    private void setDebugReal(String string, String string2) {
        ScriptInstance scriptInstance = (ScriptInstance)this.loader.getScriptsByKey().get(string);
        if (scriptInstance == null) {
            this.getCapabilities().getUserInterface().printStatus("Could not find script " + string + " to set debug level");
            return;
        }
        int n = scriptInstance.getDebugFlags();
        if (string2.indexOf("+trace") > -1) {
            n |= 8;
        }
        if (string2.indexOf("-trace") > -1) {
            n &= 0xFFFFFFF7;
        }
        if (string2.indexOf("-warn") > -1) {
            n &= 0xFFFFFFFD;
        }
        if (string2.indexOf("+warn") > -1) {
            n |= 2;
        }
        if (string2.indexOf("+all") > -1) {
            n = n | 2 | 8;
        }
        if (string2.indexOf("-all") > -1) {
            n = n & 0xFFFFFFFD & 0xFFFFFFF7;
        }
        scriptInstance.setDebugFlags(n);
        this.getCapabilities().getUserInterface().printStatus("*** Updated debug flags for " + string);
    }

    public String evalString(String string) {
        try {
            return ((ScriptInstance)this.loader.getScripts().getFirst()).getScriptEnvironment().evaluateExpression(string).toString();
        }
        catch (YourCodeSucksException yourCodeSucksException) {
            this.formatCodeException("/eval input", yourCodeSucksException);
            return string;
        }
    }

    public void reloadScript(String string) {
        boolean bl = true;
        Iterator iterator = this.findScripts(string, ClientState.getClientState().getStringList("script.files").getList()).iterator();
        while (iterator.hasNext()) {
            bl = false;
            String string2 = (String)iterator.next();
            this.removeScript(string2);
            this.addScript(string2);
        }
        if (bl) {
            this.getCapabilities().getUserInterface().printStatus("Error (re)loading script: " + string + " isn't loaded");
        }
    }

    private LinkedList findScripts(String string, LinkedList linkedList) {
        LinkedList<String> linkedList2 = new LinkedList<String>();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            File file = new File((String)iterator.next());
            if (!file.getName().equals(string) && !file.getAbsolutePath().equals(string)) continue;
            linkedList2.add(file.getAbsolutePath());
        }
        return linkedList2;
    }

    public void removeScript(String string) {
        StringList stringList = ClientState.getClientState().getStringList("script.files");
        Iterator iterator = this.findScripts(string, stringList.getList()).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringList.remove(string2);
        }
        stringList.save();
        ClientState.getClientState().sync();
    }

    public void loadLameScripts() {
        try {
            if (lame) {
                ScriptInstance scriptInstance = this.loader.loadScript("lame", ClientState.getClientState().getResourceAsStream("lame.irc"), this.environment);
                scriptInstance.addWarningWatcher(this);
                scriptInstance.runScript();
                lame = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cleanup() {
        Iterator iterator = this.loader.getScripts().iterator();
        while (iterator.hasNext()) {
            ScriptInstance scriptInstance = (ScriptInstance)iterator.next();
            scriptInstance.setUnloaded();
        }
    }

    public void loadScripts() {
        try {
            ScriptInstance scriptInstance;
            long l;
            if (ClientState.getClientState().isOption("load.default", true)) {
                l = System.currentTimeMillis();
                scriptInstance = this.loader.loadScript("default", ClientState.getClientState().getResourceAsStream("default.irc"), this.environment);
                scriptInstance.addWarningWatcher(this);
                scriptInstance.runScript();
            }
            if (ClientState.getClientState().isOption("load.menus", true)) {
                l = System.currentTimeMillis();
                scriptInstance = this.loader.loadScript("menus", ClientState.getClientState().getResourceAsStream("menus.irc"), this.environment);
                scriptInstance.addWarningWatcher(this);
                scriptInstance.runScript();
            }
            if (ClientState.getClientState().isOption("load.lame", false)) {
                this.loadLameScripts();
            }
        }
        catch (YourCodeSucksException yourCodeSucksException) {
            this.formatCodeException("<Internal Scripts>", yourCodeSucksException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Iterator iterator = ClientState.getClientState().getStringList("script.files").getList().iterator();
        while (iterator.hasNext()) {
            this.internalScriptLoad((String)iterator.next());
        }
    }

    public void propertyChanged(String string, String string2) {
        this.hashScripts();
    }

    private void internalScriptLoad(String string) {
        try {
            String string2 = this.guessCharsetFromFileName(string);
            boolean bl = this.loader.isCharsetConversions();
            String string3 = this.loader.getCharset();
            if (string2 != null) {
                this.loader.setCharsetConversion(true);
                this.loader.setCharset(string2);
            }
            ScriptInstance scriptInstance = this.loader.loadScript(string, this.environment);
            if (string2 != null) {
                this.loader.setCharsetConversion(bl);
                this.loader.setCharset(string3);
            }
            scriptInstance.addWarningWatcher(this);
            if (ClientState.getClientState().isOption("script.verboseLoad", true)) {
                this.getCapabilities().getUserInterface().printStatus("Successfully loaded script " + new File(string).getName());
            }
            scriptInstance.runScript();
        }
        catch (YourCodeSucksException yourCodeSucksException) {
            this.formatCodeException(string, yourCodeSucksException);
            this.lock = true;
            this.removeScript(string);
            this.lock = false;
        }
        catch (IOException iOException) {
            this.getCapabilities().getUserInterface().printStatus("Error loading " + new File(string).getName() + ": " + iOException.getMessage());
        }
        catch (Exception exception) {
            this.getCapabilities().getUserInterface().printStatus("Error loading " + new File(string).getName() + ": " + exception.getMessage() + " <-- could be a sleep bug, please report :)");
            exception.printStackTrace();
        }
    }

    private String guessCharsetFromFileName(String string) {
        String string2;
        File file = new File(string);
        String string3 = file.getName();
        Matcher matcher = ENCODING_IN_FILE.matcher(string3);
        Matcher matcher2 = ENCODING_IN_EXTENSION.matcher(string3);
        if (matcher.matches()) {
            if (charsets == null) {
                charsets = Charset.availableCharsets();
            }
            if (charsets.containsKey(string2 = matcher.group(1))) {
                return string2;
            }
        }
        if (matcher2.matches()) {
            string2 = matcher2.group(1);
            if (string2.equalsIgnoreCase("irc")) {
                return null;
            }
            if (charsets == null) {
                charsets = Charset.availableCharsets();
            }
            if (charsets.containsKey(string2)) {
                return string2;
            }
        }
        return null;
    }

    public void processScriptWarning(ScriptWarning scriptWarning) {
        if (!ClientState.getClientState().isOption("script.ignoreWarnings", false)) {
            String[] stringArray = scriptWarning.getMessage().split("\n");
            String string = scriptWarning.getNameShort();
            if (scriptWarning.isDebugTrace()) {
                this.getCapabilities().getUserInterface().printStatus(string + ":" + scriptWarning.getLineNumber() + " " + stringArray[0]);
            } else {
                this.getCapabilities().getUserInterface().printStatus("*** Script Warning: " + stringArray[0] + " at " + string + ":" + scriptWarning.getLineNumber());
            }
            for (int i = 1; i < stringArray.length; ++i) {
                this.getCapabilities().getUserInterface().printStatus("     " + stringArray[i]);
            }
        }
    }

    private void formatCodeException(String string, YourCodeSucksException yourCodeSucksException) {
        this.getCapabilities().getUserInterface().printStatus("*** " + yourCodeSucksException.getErrors().size() + " error(s) loading " + string);
        Iterator iterator = yourCodeSucksException.getErrors().iterator();
        while (iterator.hasNext()) {
            SyntaxError syntaxError = (SyntaxError)iterator.next();
            this.getCapabilities().getUserInterface().printStatus("Error: " + syntaxError.getDescription() + " at line " + syntaxError.getLineNumber());
            this.getCapabilities().getUserInterface().printStatus("       " + syntaxError.getCodeSnippet());
            if (syntaxError.getMarker() == null) continue;
            this.getCapabilities().getUserInterface().printStatus("       " + syntaxError.getMarker());
        }
    }
}

