/*
 * Decompiled with CFR 0.152.
 */
package rero.client.server;

import java.util.HashMap;
import rero.client.Feature;
import rero.client.output.OutputCapabilities;
import rero.client.server.SyncCheck;
import rero.client.server.UpdateIAL;
import rero.config.ClientState;
import rero.ircfw.InternalDataList;
import rero.ircfw.User;
import rero.ircfw.interfaces.ChannelDataWatch;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.ClientUtils;
import rero.util.TokenizedString;

public class ProcessEvents
extends Feature
implements FrameworkConstants,
ChatListener {
    protected InternalDataList ircData;
    protected OutputCapabilities output;
    protected SyncCheck syncs = new SyncCheck();
    private ChatListener allowAway = new AllowAwayReply();

    public void init() {
        this.output = this.getCapabilities().getOutputCapabilities();
        this.ircData = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        this.getCapabilities().addChatListener(this);
    }

    public int fireChatEvent(HashMap hashMap) {
        String string = (String)hashMap.get("$target");
        String string2 = (String)hashMap.get("$nick");
        String string3 = (String)hashMap.get("$target");
        String string4 = (String)hashMap.get("$event");
        if (string4.equals("PRIVMSG")) {
            if (ClientUtils.isChannel(string)) {
                this.output.fireSetTarget(hashMap, string3, this.output.chooseSet(string3, "CHANNEL_TEXT", "CHANNEL_TEXT_INACTIVE"));
                this.touchUser(string2, string);
            } else {
                if (ClientState.getClientState().isOption("auto.query", true)) {
                    boolean bl = !ClientState.getClientState().isOption("auto.hide", true);
                    this.getCapabilities().getUserInterface().openQueryWindow(string2, bl);
                }
                this.output.fireSetQuery(hashMap, string2, string, "PRIVMSG");
            }
        } else if (string4.equals("MODE")) {
            if (ClientUtils.isChannel(string)) {
                this.output.fireSetTarget(hashMap, string3, "CHANNEL_MODE");
                this.getCapabilities().getUserInterface().notifyWindow(string3);
            } else {
                this.output.fireSetTarget(hashMap, string2, "USER_MODE");
                this.getCapabilities().getUserInterface().notifyWindow(string2);
            }
        } else if (string4.equals("NOTICE")) {
            if (string2 == null || string2.length() == 0) {
                this.output.fireSetStatus(hashMap, "NOTICE");
            } else if (ClientUtils.isChannel(string) || ClientState.getClientState().isOption("active.notice", true)) {
                this.output.fireSetConfused(hashMap, string, "notice", "NOTICE");
            } else {
                this.output.fireSetAllTarget2(hashMap, string2, "NOTICE");
            }
        } else if (string4.equals("ACTION")) {
            if (ClientUtils.isChannel(string)) {
                this.output.fireSetTarget(hashMap, string3, this.output.chooseSet(string3, "ACTION", "ACTION_INACTIVE"));
                this.touchUser(string2, string);
            } else {
                if (ClientState.getClientState().isOption("auto.query", true)) {
                    boolean bl = !ClientState.getClientState().isOption("auto.hide", true);
                    this.getCapabilities().getUserInterface().openQueryWindow(string2, bl);
                }
                this.output.fireSetTarget(hashMap, string2, "PRIVACTION");
            }
        } else if (string4.equals("JOIN")) {
            if (hashMap.get("$nick").equals(this.ircData.getMyNick())) {
                this.syncs.addChannel(string3.toString().toLowerCase());
                this.getCapabilities().sendln("MODE " + string3.toString());
                if (ClientState.getClientState().isOption("update.ial", true)) {
                    UpdateIAL updateIAL = new UpdateIAL();
                    this.getCapabilities().addTemporaryListener(updateIAL);
                    this.getCapabilities().sendln("WHO " + string3.toString());
                }
                if (ClientState.getClientState().isOption("auto.join", true)) {
                    this.getCapabilities().getUserInterface().openChannelWindow(this.ircData.getChannel(string3));
                } else {
                    this.getCapabilities().getUserInterface().setQuery(string3.toString());
                }
            }
            this.output.fireSetTarget(hashMap, string3, "CHANNEL_JOIN");
        } else if (string4.equals("KICK")) {
            if (hashMap.get("$nick").equals(this.ircData.getMyNick())) {
                this.output.cycleQuery();
            }
            this.output.fireSetTarget(hashMap, string3, "CHANNEL_KICK");
        } else if (string4.equals("PART")) {
            if (hashMap.get("$nick").equals(this.ircData.getMyNick())) {
                this.output.cycleQuery();
            }
            if (!ClientState.getClientState().isOption("auto.part", true) || !ClientState.getClientState().isOption("auto.join", true) || this.getCapabilities().getUserInterface().isWindow(string3)) {
                this.output.fireSetTarget(hashMap, string3, "CHANNEL_PART");
            }
        } else if (string4.equals("QUIT")) {
            this.output.fireSetAllDeadTarget(hashMap, string2, "USER_QUIT");
        } else if (string4.equals("NICK")) {
            this.getCapabilities().getUserInterface().notifyActiveWindow();
            if (hashMap.containsKey("$parms")) {
                this.output.fireSetAllTarget(hashMap, hashMap.get("$parms").toString(), "USER_NICK");
            }
            if (this.getCapabilities().getUserInterface().isWindow(string2)) {
                this.getCapabilities().getUserInterface().renameWindow(string2, hashMap.get("$parms").toString());
            }
        } else if (string4.equals("TOPIC")) {
            this.output.fireSetTarget(hashMap, string3, "CHANNEL_TOPIC_CHANGED");
            this.getCapabilities().getUserInterface().notifyWindow(string3);
            this.touchUser(string2, string);
        } else if (string4.equals("SIGNON")) {
            this.output.fireSetConfused(hashMap, null, "notify", "NOTIFY_SIGNON");
        } else if (string4.equals("SIGNOFF")) {
            this.output.fireSetConfused(hashMap, null, "notify", "NOTIFY_SIGNOFF");
        } else if (string4.equals("REQUEST")) {
            String string5 = (String)hashMap.get("$type");
            if (string5.equals("VERSION")) {
                this.getCapabilities().sendln("NOTICE " + string2 + " :" + '\u0001' + "VERSION " + ClientUtils.ShowVersion() + '\u0001');
            }
            if (string5.equals("PING")) {
                this.getCapabilities().sendln("NOTICE " + string2 + " :" + '\u0001' + hashMap.get("$parms") + '\u0001');
            }
            if (string5.equals("CLIENTINFO")) {
                this.getCapabilities().sendln("NOTICE " + string2 + " :" + '\u0001' + "CLIENTINFO ACTION CLIENTINFO DCC PING SOURCE TIME VERSION" + '\u0001');
            }
            if (string5.equals("SOURCE")) {
                this.getCapabilities().sendln("NOTICE " + string2 + " :" + '\u0001' + "SOURCE http://jircii.dashnine.org" + '\u0001');
            }
            if (string5.equals("TIME")) {
                this.getCapabilities().sendln("NOTICE " + string2 + " :" + '\u0001' + "TIME " + ClientUtils.TimeDateStamp(System.currentTimeMillis() / 1000L) + '\u0001');
            }
            if (string5.equals("DCC")) {
                this.output.fireSetConfused(hashMap, string, "ctcp", "DCC_REQUEST");
            } else {
                this.output.fireSetConfused(hashMap, string, "ctcp", "CTCP_REQUEST");
            }
        } else if (string4.equals("CHAT_OPEN")) {
            string2 = "=" + hashMap.get("$nick");
            if (ClientState.getClientState().isOption("auto.chat", true)) {
                boolean bl = !ClientState.getClientState().isOption("auto.hide", true);
                this.getCapabilities().getUserInterface().openQueryWindow(string2, bl);
            }
            this.output.fireSetTarget(hashMap, string2, "CHAT_OPEN");
        } else if (string4.equals("CHAT")) {
            string2 = "=" + hashMap.get("$nick");
            this.output.fireSetTarget(hashMap, string2, "CHATMSG");
        } else if (string4.equals("ERROR")) {
            this.output.fireSetAll(hashMap, "SERVER_ERROR");
        } else if (string4.equals("CHAT_CLOSE")) {
            string2 = "=" + hashMap.get("$nick");
            if (!ClientState.getClientState().isOption("auto.chatclose", true) || this.getCapabilities().getUserInterface().isWindow(string2)) {
                this.output.fireSetTarget(hashMap, string2, "CHAT_CLOSE");
            }
        } else if (string4.equals("SEND_FAILED") || string4.equals("RECEIVE_FAILED") || string4.equals("SEND_COMPLETE") || string4.equals("RECEIVE_COMPLETE") || string4.equals("SEND_START") || string4.equals("RECEIVE_START")) {
            this.output.fireSetConfused(hashMap, string2, "ctcp", string4);
            this.getCapabilities().getUserInterface().notifyActiveWindow();
        } else if (string4.equals("REPLY")) {
            TokenizedString tokenizedString = new TokenizedString((String)hashMap.get("$parms"));
            tokenizedString.tokenize(" ");
            if (tokenizedString.getToken(0).equals("PING") && tokenizedString.getTotalTokens() > 1) {
                try {
                    long l = Long.parseLong(tokenizedString.getToken(1));
                    hashMap.put("$pt", ClientUtils.formatLongAsDecimal(System.currentTimeMillis() - l) + "s");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.output.fireSetConfused(hashMap, (String)hashMap.get("$target"), "reply", "CTCP_REPLY");
        } else if (string4.equals("INVITE")) {
            this.output.fireSetActive(hashMap, "INVITE");
        } else if (string4.equals("329") && this.output.isSet("CHANNEL_CREATED")) {
            TokenizedString tokenizedString = new TokenizedString((String)hashMap.get("$parms"));
            tokenizedString.tokenize(" ");
            hashMap.put("$created", ClientUtils.TimeDateStamp(Long.parseLong(tokenizedString.getToken(1))));
            this.output.fireSetTarget(hashMap, tokenizedString.getToken(0), "CHANNEL_CREATED");
        } else if (string4.equals("324")) {
            TokenizedString tokenizedString = new TokenizedString((String)hashMap.get("$parms"));
            tokenizedString.tokenize(" ");
            string3 = tokenizedString.getToken(0);
            if (this.syncs.isSyncing(string3.toLowerCase())) {
                hashMap.put("$sync", ClientUtils.formatLongAsDecimal(this.syncs.getSyncTime(string3.toLowerCase())));
                this.output.fireSetTarget(hashMap, string3, "JOIN_SYNC");
            } else if (this.output.isSet("CHANNEL_MODE_IS")) {
                hashMap.put("$parms", tokenizedString.getTokenFrom(1));
                hashMap.put("$data", tokenizedString.getTokenFrom(0));
                this.output.fireSetTarget(hashMap, tokenizedString.getToken(0), "CHANNEL_MODE_IS");
            } else {
                this.processNumeric("324", hashMap);
            }
            this.getCapabilities().getUserInterface().notifyWindow(string3);
        } else if ((string4.equals("332") || string4.equals("331")) && this.output.isSet("CHANNEL_TOPIC_IS")) {
            TokenizedString tokenizedString = new TokenizedString((String)hashMap.get("$parms"));
            tokenizedString.tokenize(" ");
            hashMap.put("$parms", tokenizedString.getTokenFrom(1));
            hashMap.put("$data", tokenizedString.getTokenFrom(0));
            this.output.fireSetTarget(hashMap, tokenizedString.getToken(0), "CHANNEL_TOPIC_IS");
        } else if (string4.equals("333") && this.output.isSet("CHANNEL_TOPIC_SETBY")) {
            TokenizedString tokenizedString = new TokenizedString((String)hashMap.get("$parms"));
            tokenizedString.tokenize(" ");
            hashMap.put("$seton", ClientUtils.TimeDateStamp(Long.parseLong(tokenizedString.getToken(2))));
            string2 = tokenizedString.getToken(1);
            if (string2.indexOf(33) > -1) {
                string2 = string2.substring(0, string2.indexOf(33));
            }
            hashMap.put("$nick", string2);
            this.output.fireSetTarget(hashMap, tokenizedString.getToken(0), "CHANNEL_TOPIC_SETBY");
        } else if (string4.equals("353") && this.output.isSet("CHANNEL_NAMES")) {
            TokenizedString tokenizedString = new TokenizedString((String)hashMap.get("$parms"));
            tokenizedString.tokenize(" ");
            this.output.fireSetTarget(hashMap, tokenizedString.getToken(1), "CHANNEL_NAMES");
        } else if (string4.equals("353") && this.output.isSet("FORMATTED_NAMES")) {
            TokenizedString tokenizedString = new TokenizedString((String)hashMap.get("$parms"));
            tokenizedString.tokenize(" ");
            hashMap.put("$total", tokenizedString.getTotalTokens() - 2 + "");
            this.output.fireSetTarget(hashMap, tokenizedString.getToken(1), "FORMATTED_NAMES_HEADER");
            if (tokenizedString.getTotalTokens() < 3 || tokenizedString.getToken(2).equals(":")) {
                return 0;
            }
            String[] stringArray = new String[tokenizedString.getTotalTokens() - 2];
            for (int i = 0; i < stringArray.length; ++i) {
                char c = tokenizedString.getToken(i + 2).charAt(0);
                if (this.ircData.getPrefixInfo().isPrefixChar(c)) {
                    hashMap.put("$nick", tokenizedString.getToken(i + 2).substring(1, tokenizedString.getToken(i + 2).length()));
                } else {
                    hashMap.put("$nick", tokenizedString.getToken(i + 2));
                }
                stringArray[i] = this.output.parseSet(hashMap, "FORMATTED_NAMES");
            }
            this.output.echo(tokenizedString.getToken(1), stringArray, 0.85);
        } else if (string4.equals("367") && this.output.isSet("CHANNEL_BANLIST")) {
            TokenizedString tokenizedString = new TokenizedString((String)hashMap.get("$parms"));
            tokenizedString.tokenize(" ");
            this.output.fireSetTarget(hashMap, tokenizedString.getToken(0), "CHANNEL_BANLIST");
        } else if (string4.equals("368") && this.output.isSet("CHANNEL_BANLIST_END")) {
            TokenizedString tokenizedString = new TokenizedString((String)hashMap.get("$parms"));
            tokenizedString.tokenize(" ");
            this.output.fireSetTarget(hashMap, tokenizedString.getToken(0), "CHANNEL_BANLIST_END");
        } else if (!string4.equals("375") && !string4.equals("376") && !string4.equals("372") || ClientState.getClientState().isOption("option.showmotd", true)) {
            if (hashMap.get("$numeric") != null) {
                String string6 = (String)hashMap.get("$numeric");
                this.processNumeric(string6, hashMap);
            } else {
                this.output.fireSetStatus(hashMap, string4);
            }
        }
        return 0;
    }

    public void processNumeric(String string, HashMap hashMap) {
        int n = Integer.parseInt(string);
        String string2 = "NUMERIC";
        if (this.output.isSet("REPL_" + string)) {
            string2 = "REPL_" + string;
        }
        if (ProcessEvents.isWhoisNumeric(n)) {
            if (!this.allowAway.isChatEvent(string, hashMap) || this.allowAway.fireChatEvent(hashMap) != 2) {
                this.output.fireSetConfused(hashMap, null, "whois", string2);
            }
        } else {
            this.output.fireSetStatus(hashMap, string2);
        }
    }

    public boolean isChatEvent(String string, HashMap hashMap) {
        return true;
    }

    private static boolean isWhoisNumeric(int n) {
        return n >= 311 && n < 321 || n == 338 || n == 369 || n == 301 || n == 302 || n == 307 || n == 308 || n == 330 || n == 401 || n == 406 || n == 378 || n == 379 || n == 310 || n == 671 || n == 703;
    }

    private void touchUser(String string, String string2) {
        ChannelDataWatch channelDataWatch;
        User user = this.ircData.getUser(string);
        boolean bl = user.isIdle();
        user.touch();
        if (bl && this.ircData.getChannel(string2) != null && (channelDataWatch = this.ircData.getChannelDataWatch(this.ircData.getChannel(string2))) != null) {
            channelDataWatch.userChanged();
        }
    }

    private static class AllowAwayReply
    implements ChatListener {
        private boolean awayIsGood = false;

        private AllowAwayReply() {
        }

        public boolean isChatEvent(String string, HashMap hashMap) {
            return string.equals("301") || string.equals("311") || string.equals("318");
        }

        public int fireChatEvent(HashMap hashMap) {
            if ("311".equals(hashMap.get("$event"))) {
                this.awayIsGood = true;
            }
            if ("318".equals(hashMap.get("$event"))) {
                this.awayIsGood = false;
            }
            if ("301".equals(hashMap.get("$event")) && !this.awayIsGood) {
                return 2;
            }
            return 1;
        }
    }
}

