/*
 * Decompiled with CFR 0.152.
 */
package rero.config;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.swing.ImageIcon;
import rero.config.ClientStateListener;
import rero.config.StringList;
import rero.util.ClientUtils;

public class ClientState {
    protected static HashMap listeners = new HashMap();
    protected Set changes;
    protected Properties backup;
    protected static File baseDirectory = new File(System.getProperty("user.home"), ".jIRC");
    protected Properties state = new Properties();
    protected static ClientState clientState = null;

    public static void setBaseDirectory(String string) {
        baseDirectory = new File(string);
    }

    public void fireChange(String string) {
        this.fireChange(string, null);
    }

    public void addClientStateListener(String string, ClientStateListener clientStateListener) {
        LinkedList<WeakReference<ClientStateListener>> linkedList = (LinkedList<WeakReference<ClientStateListener>>)listeners.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<WeakReference<ClientStateListener>>();
            listeners.put(string, linkedList);
        }
        linkedList.add(new WeakReference<ClientStateListener>(clientStateListener));
    }

    public void fireChange(String string, String string2) {
        if (listeners.get(string) == null) {
            return;
        }
        Iterator iterator = ((LinkedList)listeners.get(string)).iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() == null) {
                iterator.remove();
                continue;
            }
            ClientStateListener clientStateListener = (ClientStateListener)weakReference.get();
            clientStateListener.propertyChanged(string, string2);
        }
    }

    public static InputStreamReader getProperInputStream(InputStream inputStream) {
        if (ClientState.getClientState().getString("client.encoding", "Platform Default").equals("Platform Default")) {
            return new InputStreamReader(inputStream);
        }
        try {
            return new InputStreamReader(inputStream, ClientState.getClientState().getString("client.encoding", "Platform Default"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new InputStreamReader(inputStream);
        }
    }

    public static PrintStream getProperPrintStream(OutputStream outputStream) {
        if (ClientState.getClientState().getString("client.encoding", "Platform Default").equals("Platform Default")) {
            return new PrintStream(outputStream, true);
        }
        try {
            return new PrintStream(outputStream, true, ClientState.getClientState().getString("client.encoding", "Platform Default"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new PrintStream(outputStream, true);
        }
    }

    public static File getBaseDirectory() {
        if (!baseDirectory.exists() || !baseDirectory.isDirectory()) {
            baseDirectory.delete();
            baseDirectory.mkdirs();
        }
        return baseDirectory;
    }

    public static ClientState getClientState() {
        if (clientState == null) {
            clientState = new ClientState();
        }
        return clientState;
    }

    public ClientState() {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(ClientState.getBaseDirectory(), "jirc.prop"));
            this.state.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.changes = new HashSet();
    }

    public void backup() {
        this.backup = (Properties)this.state.clone();
        this.changes.clear();
    }

    public void restore() {
        this.state = this.backup;
        this.sync();
        Iterator iterator = this.changes.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.fireChange(string);
        }
    }

    public void sync() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(ClientState.getBaseDirectory(), "jirc.prop"));
            this.state.save(fileOutputStream, "Java IRC Configuration");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Properties getProperties() {
        return this.state;
    }

    public void setString(String string, String string2) {
        this.state.setProperty(string, string2);
        this.fireChange(string);
    }

    public String getString(String string, String string2) {
        String string3 = this.state.getProperty(string);
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        return string3;
    }

    public Rectangle getBounds(String string, Dimension dimension, Dimension dimension2) {
        String string2 = this.state.getProperty(string);
        if (string2 == null) {
            int n = (int)(dimension.getWidth() - dimension2.getWidth()) / 2;
            int n2 = (int)(dimension.getHeight() - dimension2.getHeight()) / 2;
            if (n <= 0 || n2 <= 0) {
                n = 0;
                n2 = 0;
            }
            return new Rectangle(n, n2, (int)dimension2.getWidth(), (int)dimension2.getHeight());
        }
        String[] stringArray = string2.split("x");
        Rectangle rectangle = new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        return rectangle;
    }

    public float getFloat(String string, float f) {
        String string2 = this.state.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            return f;
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (Exception exception) {
            return f;
        }
    }

    public void setFloat(String string, float f) {
        this.setString(string, f + "");
    }

    public int getInteger(String string, int n) {
        String string2 = this.state.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public void setInteger(String string, int n) {
        this.setString(string, n + "");
    }

    public void setOption(String string, boolean bl) {
        if (bl) {
            this.setString(string, "true");
        } else {
            this.setString(string, "false");
        }
        this.fireChange(string);
    }

    public boolean isOption(String string, boolean bl) {
        String string2 = this.getString(string, null);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("true");
    }

    public Color getColor(String string, Color color) {
        String string2 = this.getString(string, null);
        if (string2 == null) {
            return color;
        }
        return Color.decode(string2);
    }

    public void setColor(String string, Color color) {
        this.setString(string, color.getRGB() + "");
    }

    public StringList getStringList(String string) {
        return new StringList(string);
    }

    public boolean isValue(String string, String string2) {
        return this.getStringList(string).isValue(string2);
    }

    public static File getFile(String string) {
        return new File(ClientState.getBaseDirectory(), string);
    }

    public URL getResource(String string) {
        return this.getPackagedResource(string, "resource");
    }

    public String getHelpString(String string) {
        string = string.replaceAll("\\'", "").replaceAll("\\?", "").replaceAll(" ", "_");
        try {
            String string2;
            URL uRL = this.getPackagedResource(string, "help");
            if (uRL == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public URL getPackagedResource(String string, String string2) {
        try {
            File file = new File(ClientState.getBaseDirectory(), string);
            if (file.exists()) {
                return file.toURL();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.getClass().getResource("/" + string2 + "/" + string);
    }

    public InputStream getResourceAsStream(String string) {
        Serializable serializable;
        try {
            serializable = new File(string);
            if (((File)serializable).exists()) {
                return ((File)serializable).toURL().openStream();
            }
            File file = new File(ClientState.getBaseDirectory(), string);
            if (file.exists()) {
                return file.toURL().openStream();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serializable = this.getResource(string);
        if (serializable == null) {
            return null;
        }
        try {
            return ((URL)serializable).openStream();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Font getFont(String string, Font font) {
        String string2 = this.getString(string, null);
        if (string2 == null) {
            return font;
        }
        return Font.decode(string2);
    }

    public void setFont(String string, Font font) {
        this.setString(string, ClientUtils.encodeFont(font));
    }

    public ImageIcon getIcon(String string, String string2) {
        String string3 = this.getString(string, null);
        if (string3 == null) {
            return new ImageIcon(this.getResource(string2));
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(string3));
    }

    public void setBounds(String string, Rectangle rectangle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((int)rectangle.getX());
        stringBuffer.append('x');
        stringBuffer.append((int)rectangle.getY());
        stringBuffer.append('x');
        stringBuffer.append((int)rectangle.getWidth());
        stringBuffer.append('x');
        stringBuffer.append((int)rectangle.getHeight());
        this.setString(string, stringBuffer.toString());
    }
}

