/*
 * Decompiled with CFR 0.152.
 */
package rero.config;

import java.util.LinkedList;
import java.util.ListIterator;
import rero.config.ClientState;

public class StringList {
    protected LinkedList values;
    protected String key;

    public StringList(String string) {
        this.key = string;
        this.load();
    }

    public void load() {
        String string = ClientState.getClientState().getString(this.key, null);
        LinkedList<String> linkedList = new LinkedList<String>();
        if (string != null) {
            String[] stringArray = string.split("::");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() <= 0) continue;
                linkedList.add(stringArray[i]);
            }
        }
        this.values = linkedList;
    }

    public boolean isValue(String string) {
        return this.values.contains(string);
    }

    public LinkedList getList() {
        return this.values;
    }

    public void save() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.values.size() > 0) {
            stringBuffer.append(this.values.getFirst());
            ListIterator listIterator = this.values.listIterator(1);
            while (listIterator.hasNext()) {
                stringBuffer.append("::");
                stringBuffer.append(listIterator.next().toString());
            }
        }
        ClientState.getClientState().setString(this.key, stringBuffer.toString());
    }

    public void add(String string) {
        this.values.add(string);
    }

    public void remove(String string) {
        ListIterator listIterator = this.values.listIterator();
        while (listIterator.hasNext()) {
            if (!listIterator.next().toString().equals(string)) continue;
            listIterator.remove();
        }
        this.save();
        ClientState.getClientState().fireChange(this.key, string);
    }

    public void clear() {
        this.values = new LinkedList();
        this.save();
        ClientState.getClientState().fireChange(this.key);
    }
}

