/*
 * Decompiled with CFR 0.152.
 */
package rero.dcc;

import java.io.BufferedReader;
import java.io.PrintStream;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.dcc.ProtocolDCC;

public class Chat
extends ProtocolDCC
implements ClientStateListener {
    protected BufferedReader input;
    protected PrintStream output;

    public Chat(String string) {
        this.nickname = string;
        ClientState.getClientState().addClientStateListener("client.encoding", this);
    }

    public void propertyChanged(String string, String string2) {
        try {
            if (this.input != null && this.socket.isConnected()) {
                ClientState.getClientState();
                this.input = new BufferedReader(ClientState.getProperInputStream(this.socket.getInputStream()));
                ClientState.getClientState();
                this.output = ClientState.getProperPrintStream(this.socket.getOutputStream());
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to switch encodings...");
            exception.printStackTrace();
        }
    }

    public String getNickname() {
        return this.nickname;
    }

    public void sendln(String string) {
        this.output.println(string);
    }

    public int getTypeOfDCC() {
        return 3;
    }

    public void run() {
        if (this.socket == null || !this.socket.isConnected()) {
            return;
        }
        try {
            this.socket.setKeepAlive(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fireEvent("CHAT_OPEN", null);
        try {
            ClientState.getClientState();
            this.output = ClientState.getProperPrintStream(this.socket.getOutputStream());
            ClientState.getClientState();
            this.input = new BufferedReader(ClientState.getProperInputStream(this.socket.getInputStream()));
            while (this.socket.isConnected()) {
                String string = this.input.readLine();
                if (string == null) {
                    this.fireEvent("CHAT_CLOSE", "closed");
                    return;
                }
                this.idleTime = System.currentTimeMillis();
                this.fireEvent("CHAT", string);
            }
            this.fireEvent("CHAT_CLOSE", "closed");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.fireError(exception.getMessage());
        }
    }

    public void fireEvent(String string, String string2) {
        this.eventData.clear();
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", string);
        this.eventData.put("$this", this.toString());
        if (string2 != null) {
            this.eventData.put("$data", this.getNickname() + " " + string2);
            this.eventData.put("$parms", string2);
        }
        this.dispatcher.dispatchEvent(this.eventData);
    }

    public void fireError(String string) {
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", "CHAT_CLOSE");
        this.eventData.put("$data", this.getNickname() + " " + string);
        this.eventData.put("$parms", string);
        this.eventData.put("$this", this.toString());
        this.dispatcher.dispatchEvent(this.eventData);
    }
}

