/*
 * Decompiled with CFR 0.152.
 */
package rero.dcc;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import rero.dcc.ProtocolDCC;

public class Send
extends ProtocolDCC {
    protected static int PACKET_SIZE = 4096;
    protected File dumpFrom;
    protected FileInputStream fileStream;
    protected long sentSize;
    protected long ackSize;
    protected long finalSize;
    protected long startSize;

    public boolean resume(long l) {
        if (l < this.dumpFrom.length()) {
            this.sentSize = l;
            this.startSize = l;
            return true;
        }
        return false;
    }

    public Send(String string, File file) {
        this.nickname = string;
        this.dumpFrom = file;
        this.finalSize = file.length();
        this.ackSize = 0L;
        this.sentSize = 0L;
        this.startSize = 0L;
        this.eventData = new HashMap();
    }

    public long getBytesSent() {
        return this.sentSize;
    }

    public long getAcknowledgedSize() {
        return this.ackSize;
    }

    public File getFile() {
        return this.dumpFrom;
    }

    public long getStartOffset() {
        return this.startSize;
    }

    public long getTimeRemaining() {
        long l = this.getFile().length() - this.getBytesSent();
        long l2 = this.getTransferRate();
        if (l2 == 0L) {
            l2 = 1000L;
        }
        return l / l2;
    }

    public int getTransferRate() {
        if (this.getTotalTime() < 1000L) {
            return 1000;
        }
        return (int)((this.getBytesSent() - this.getStartOffset()) / (this.getTotalTime() / 1000L));
    }

    public int getTypeOfDCC() {
        return 1;
    }

    private static void skipFully(InputStream inputStream, long l) throws IOException {
        long l2;
        for (long i = l; i != 0L; i -= l2) {
            l2 = inputStream.skip(i);
            if (l2 != 0L) continue;
            throw new EOFException();
        }
    }

    public void run() {
        block13: {
            if (this.socket == null || !this.socket.isConnected()) {
                return;
            }
            try {
                this.socket.setSoTimeout(120000);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.fireEvent("SEND_START", null);
            DataInputStream dataInputStream = null;
            OutputStream outputStream = null;
            byte[] byArray = new byte[PACKET_SIZE];
            try {
                this.fileStream = new FileInputStream(this.dumpFrom);
                Send.skipFully(this.fileStream, this.sentSize);
                dataInputStream = new DataInputStream(this.socket.getInputStream());
                outputStream = this.socket.getOutputStream();
                while (this.socket.isConnected() && this.sentSize < this.finalSize) {
                    int n = this.finalSize - this.sentSize < (long)PACKET_SIZE ? this.fileStream.read(byArray, 0, (int)(this.finalSize - this.sentSize)) : this.fileStream.read(byArray, 0, PACKET_SIZE);
                    if (n > 0) {
                        outputStream.write(byArray, 0, n);
                        outputStream.flush();
                        this.sentSize += (long)n;
                    }
                    if (dataInputStream.available() < 4) continue;
                    this.ackSize = 0L;
                    this.ackSize += (long)(dataInputStream.readUnsignedByte() << 24);
                    this.ackSize += (long)(dataInputStream.readUnsignedByte() << 16);
                    this.ackSize += (long)(dataInputStream.readUnsignedByte() << 8);
                    this.ackSize += (long)(dataInputStream.readUnsignedByte() << 0);
                    this.idleTime = System.currentTimeMillis();
                }
                while (this.socket.isConnected() && this.ackSize < this.finalSize && this.getIdleTime() < 10000L) {
                    if (dataInputStream.available() >= 4) {
                        this.ackSize = 0L;
                        this.ackSize += (long)(dataInputStream.readUnsignedByte() << 24);
                        this.ackSize += (long)(dataInputStream.readUnsignedByte() << 16);
                        this.ackSize += (long)(dataInputStream.readUnsignedByte() << 8);
                        this.ackSize += (long)(dataInputStream.readUnsignedByte() << 0);
                        this.idleTime = System.currentTimeMillis();
                        continue;
                    }
                    Thread.sleep(500L);
                }
            }
            catch (Exception exception) {
                if (this.sentSize == this.finalSize) break block13;
                exception.printStackTrace();
                this.fireError(exception.getMessage());
                return;
            }
        }
        try {
            this.fileStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.sentSize == this.finalSize) {
            this.fireEvent("SEND_COMPLETE", null);
        } else {
            this.fireError("incomplete");
        }
    }

    public void fireError(String string) {
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", "SEND_FAILED");
        this.eventData.put("$data", this.getNickname() + " " + string);
        this.eventData.put("$parms", string);
        this.eventData.put("$this", this.toString());
        this.dispatcher.dispatchEvent(this.eventData);
    }

    public void fireEvent(String string, String string2) {
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", string);
        this.eventData.put("$data", this.getNickname() + " " + string2);
        this.eventData.put("$parms", string2);
        this.eventData.put("$this", this.toString());
        this.dispatcher.dispatchEvent(this.eventData);
    }
}

