/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rero.config.ClientState;
import rero.dck.SuperInput;

public class CharsetInput
extends SuperInput {
    public static final String DEFAULT_CHARSET = "Platform Default";
    protected JComboBox name;
    protected boolean listing = true;
    protected JLabel label;

    public CharsetInput(String string, String string2, char c, int n) {
        this.variable = string;
        this.setLayout(new BorderLayout());
        this.name = new JComboBox();
        this.name.addItem("Loading Charsets...");
        this.add((Component)this.name, "Center");
        if (n > 0) {
            JPanel jPanel = new JPanel();
            jPanel.setPreferredSize(new Dimension(n, 0));
            this.add((Component)jPanel, "East");
        }
        this.label = new JLabel("  " + string2 + " ");
        this.label.setDisplayedMnemonic(c);
        this.add((Component)this.label, "West");
    }

    public void setAlignWidth(int n) {
        this.label.setPreferredSize(new Dimension(n, 0));
        this.revalidate();
    }

    public void save() {
        ClientState.getClientState().setString(this.getVariable(), this.name.getSelectedItem().toString());
    }

    public JComponent getComponent() {
        return this;
    }

    public int getEstimatedWidth() {
        return (int)this.label.getPreferredSize().getWidth();
    }

    public void refresh() {
        if (!this.listing) {
            this.name.setSelectedItem(ClientState.getClientState().getString(this.getVariable(), DEFAULT_CHARSET));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CharsetInput.this.name.addItem(CharsetInput.DEFAULT_CHARSET);
                    Iterator<String> iterator = Charset.availableCharsets().keySet().iterator();
                    while (iterator.hasNext()) {
                        CharsetInput.this.name.addItem(iterator.next().toString());
                    }
                    CharsetInput.this.name.removeItemAt(0);
                    CharsetInput.this.listing = false;
                    CharsetInput.this.refresh();
                    CharsetInput.this.revalidate();
                }
            });
        }
    }
}

