/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.FlowLayout;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rero.config.ClientState;
import rero.dck.DItem;
import rero.dck.SuperInput;

public class CheckboxInput
extends SuperInput
implements ChangeListener {
    protected LinkedList enabledTrue = new LinkedList();
    protected LinkedList enabledFalse = new LinkedList();
    protected JCheckBox box;
    protected boolean defaultVal;

    public CheckboxInput(String string, boolean bl, String string2, char c) {
        this(string, bl, string2, c, 0);
    }

    public CheckboxInput(String string, boolean bl, String string2, char c, int n) {
        this.setLayout(new FlowLayout(n, 0, 0));
        this.box = new JCheckBox(string2);
        this.box.addChangeListener(this);
        this.add(this.box);
        this.box.setMnemonic(c);
        this.setPreferredSize(this.box.getPreferredSize());
        this.variable = string;
        this.defaultVal = bl;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.handleDependents();
        this.notifyParent();
    }

    public void addDependent(DItem dItem) {
        this.enabledTrue.add(dItem);
    }

    public void addAntiDependent(DItem dItem) {
        this.enabledFalse.add(dItem);
    }

    public void save() {
        ClientState.getClientState().setOption(this.getVariable(), this.box.isSelected());
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int n) {
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.box.setSelected(ClientState.getClientState().isOption(this.getVariable(), this.defaultVal));
        this.handleDependents();
    }

    public void handleDependents() {
        DItem dItem;
        Iterator iterator = this.enabledTrue.iterator();
        while (iterator.hasNext()) {
            dItem = (DItem)iterator.next();
            dItem.setEnabled(this.box.isSelected());
        }
        iterator = this.enabledFalse.iterator();
        while (iterator.hasNext()) {
            dItem = (DItem)iterator.next();
            dItem.setEnabled(!this.box.isSelected());
        }
    }

    public JCheckBox getCheckBox() {
        return this.box;
    }
}

