/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import rero.config.ClientState;
import rero.dck.SmallButton;
import rero.dck.SuperInput;

public class FileInput
extends SuperInput
implements ActionListener {
    protected JLabel label;
    protected JTextField text = new JTextField();
    protected SmallButton button = new SmallButton(this.text.getBorder(), "Click to open a file chooser");
    protected String value;
    protected JFileChooser chooser;
    protected boolean directory;

    public FileInput(String string, String string2, String string3, char c, boolean bl, int n) {
        this.label = new JLabel(string3);
        this.button.addActionListener(this);
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)this.label, "West");
        this.add((Component)this.text, "Center");
        this.add((Component)this.button, "East");
        this.label.setLabelFor(this.button);
        this.label.setDisplayedMnemonic(c);
        this.variable = string;
        this.value = string2;
        this.directory = bl;
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, n));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        if (this.directory) {
            this.chooser.setApproveButtonText("Select Directory");
            this.chooser.setFileSelectionMode(1);
        } else {
            this.chooser.setApproveButtonText("Select File");
        }
        if (this.chooser.showDialog(this, null) == 0) {
            this.text.setText(this.chooser.getSelectedFile().getAbsolutePath());
            this.text.requestFocus();
        }
        this.notifyParent();
    }

    public void save() {
        ClientState.getClientState().setString(this.getVariable(), this.text.getText());
    }

    public int getEstimatedWidth() {
        return (int)this.label.getPreferredSize().getWidth();
    }

    public void setAlignWidth(int n) {
        this.label.setPreferredSize(new Dimension(n, 0));
        this.revalidate();
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.text.setText(ClientState.getClientState().getString(this.getVariable(), this.value));
    }
}

