/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rero.config.ClientState;
import rero.dck.SuperInput;

public class FontInput
extends SuperInput
implements ItemListener {
    protected JComboBox name;
    protected JComboBox style;
    protected JComboBox size;
    protected JLabel preview;
    protected Font value;
    protected boolean listing = true;

    public static String funny() {
        String[] stringArray = new String[]{"The quick brown fox jumped over the lazy coder", "Fat butane, grubbin' on French fries", "Sun sucks!@"};
        int n = (int)System.currentTimeMillis() / 1000 % stringArray.length;
        return stringArray[Math.abs(n)];
    }

    public FontInput(String string, Font font) {
        this.variable = string;
        this.value = font;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        this.name = new JComboBox();
        this.name.setPrototypeDisplayValue("Times New Roman.");
        this.name.addItem("Loading fonts...");
        this.style = new JComboBox<String>(new String[]{"Plain", "Italic", "Bold"});
        this.size = new JComboBox<String>(new String[]{"5", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "20", "22", "26", "32"});
        this.name.addItemListener(this);
        this.style.addItemListener(this);
        this.size.addItemListener(this);
        jPanel2.add(this.name);
        jPanel2.add(this.style);
        jPanel2.add(this.size);
        jPanel.add((Component)jPanel2, "Center");
        this.preview = new JLabel(FontInput.funny());
        this.preview.setOpaque(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        jPanel3.add(this.preview);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel3, "Center");
    }

    public void save() {
        ClientState.getClientState().setFont(this.getVariable(), this.preview.getFont());
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int n) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Font font = Font.decode(this.name.getSelectedItem() + "-" + this.style.getSelectedItem().toString().toUpperCase() + "-" + this.size.getSelectedItem());
        this.preview.setFont(font);
        this.preview.revalidate();
        this.notifyParent();
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        if (!this.listing) {
            Font font = ClientState.getClientState().getFont(this.getVariable(), this.value);
            this.name.setSelectedItem(font.getFamily());
            this.size.setSelectedItem(font.getSize() + "");
            if (font.isBold()) {
                this.style.setSelectedItem("Bold");
            } else if (font.isItalic()) {
                this.style.setSelectedItem("Italic");
            } else {
                this.style.setSelectedItem("Plain");
            }
            this.preview.setFont(font);
            this.preview.validate();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        FontInput.this.name.addItem(stringArray[i]);
                    }
                    FontInput.this.name.removeItemAt(0);
                    FontInput.this.listing = false;
                    FontInput.this.refresh();
                    FontInput.this.revalidate();
                }
            });
        }
    }
}

