/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rero.config.ClientState;
import rero.config.StringList;
import rero.dck.SuperInput;

public class ListInput
extends SuperInput
implements ActionListener {
    protected InputListModel model;
    protected JList list;
    protected StringList data;
    protected String desc;
    protected String title;

    public ListInput(String string, String string2, String string3, int n, int n2) {
        this.title = string2;
        this.desc = string3;
        this.setLayout(new BorderLayout());
        this.data = ClientState.getClientState().getStringList(string);
        this.data.load();
        this.model = new InputListModel();
        this.list = new JList(this.model);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(n, n2));
        this.add((Component)jPanel, "East");
        jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(n, n2));
        this.add((Component)jPanel, "West");
        this.add((Component)new JScrollPane(this.list), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        JButton jButton = new JButton("Add");
        jButton.setMnemonic('A');
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Remove");
        jButton2.setMnemonic('R');
        jButton2.addActionListener(this);
        jPanel2.add(jButton2);
        this.add((Component)jPanel2, "South");
        this.setMinimumSize(new Dimension(n, n2));
    }

    public void save() {
        this.data.save();
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int n) {
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.data.load();
        this.model.fireChange();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getActionCommand().equals("Remove") && this.list.getSelectedIndex() >= 0) {
            this.data.getList().remove(this.list.getSelectedIndex());
            this.model.fireChange();
        }
        if (actionEvent.getActionCommand().equals("Add") && (string = JOptionPane.showInputDialog(this, this.title, this.desc, 3)) != null) {
            this.data.getList().add(string);
            this.model.fireChange();
        }
        this.notifyParent();
    }

    protected class InputListModel
    extends AbstractListModel {
        protected InputListModel() {
        }

        public void fireChange() {
            ListInput.this.model.fireContentsChanged(ListInput.this.model, 0, ListInput.this.model.getSize());
        }

        public Object getElementAt(int n) {
            return (String)ListInput.this.data.getList().get(n);
        }

        public int getSize() {
            return ListInput.this.data.getList().size();
        }
    }
}

