/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rero.config.ClientState;
import rero.config.StringList;
import rero.dck.DCapabilities;
import rero.dck.DItem;
import rero.dck.DParent;
import rero.dialogs.server.Server;
import rero.dialogs.server.ServerData;
import rero.dialogs.server.ServerGroup;
import rero.dialogs.toolkit.ADialog;
import rero.dialogs.toolkit.APanel;
import rero.dialogs.toolkit.LabelGroup;
import rero.gui.SessionManager;

public class ServerList
extends JPanel
implements DItem {
    protected int height;
    protected int width;
    protected JButton connect;
    protected JButton edit;
    protected JComboBox network;
    protected JList list;
    protected ServerData data;
    protected StringList autoConnect;
    protected JComponent component;
    protected DCapabilities capabilities;

    public ServerList(ServerData serverData, int n, int n2, DCapabilities dCapabilities) {
        this.data = serverData;
        this.autoConnect = ClientState.getClientState().getStringList("auto.connect");
        this.capabilities = dCapabilities;
        this.width = n;
        this.height = n2;
        this.component = this;
        this.setBorder(BorderFactory.createEmptyBorder(0, this.width, 0, this.width));
        this.setLayout(new BorderLayout());
        this.connect = new JButton("Connect");
        this.connect.setMnemonic('C');
        this.edit = new JButton("Edit");
        this.edit.setMnemonic('E');
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.connect);
        jPanel.add(this.edit);
        this.network = new JComboBox(new NetworkListModel());
        this.network.setPrototypeDisplayValue("Random Servers");
        jPanel.add(this.network);
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerEditorDialog serverEditorDialog = new ServerEditorDialog(ServerList.this.component);
                serverEditorDialog.getListbox().setSelectedIndex(ServerList.this.list.getSelectedIndex());
                serverEditorDialog.getListbox().ensureIndexIsVisible(ServerList.this.list.getSelectedIndex());
                serverEditorDialog.showDialog(ServerList.this.component);
                ServerList.this.data.update();
                ((ServerListModel)ServerList.this.list.getModel()).fireChange();
                ((NetworkListModel)ServerList.this.network.getModel()).fireChange();
            }
        });
        this.network.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerList.this.data.setActive((ServerGroup)ServerList.this.network.getSelectedItem());
                ((ServerListModel)ServerList.this.list.getModel()).fireChange();
            }
        });
        this.connect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerList.this.handleConnectAction();
            }
        });
        this.add((Component)jPanel, "South");
        ServerListModel serverListModel = new ServerListModel();
        this.list = new JList(serverListModel);
        this.list.setCellRenderer(serverListModel);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ServerList.this.handleConnectAction();
                        }
                    });
                    mouseEvent.consume();
                }
            }
        });
        this.add((Component)new JScrollPane(this.list, 22, 30), "Center");
        this.setPreferredSize(new Dimension(0, this.height));
    }

    public void handleConnectAction() {
        this.capabilities.forceSave();
        if (SessionManager.getGlobalCapabilities().getActiveSession().getCapabilities().isConnected()) {
            SessionManager.getGlobalCapabilities().createNewServer();
        }
        if (this.list.getSelectedValue() != null) {
            Server server = (Server)this.list.getSelectedValue();
            SessionManager.getGlobalCapabilities().getActiveSession().executeCommand(server.getCommand());
            this.capabilities.closeDialog();
        } else {
            JOptionPane.showMessageDialog(null, "Please select a server", "Warning", 2);
        }
    }

    public void setParent(DParent dParent) {
    }

    public void setEnabled(boolean bl) {
    }

    public void save() {
        if (this.network.getSelectedItem() != null) {
            ClientState.getClientState().setInteger("sdialog.selected", ((ServerGroup)this.network.getSelectedItem()).getNumber());
        }
        this.data.save();
    }

    public void refresh() {
        try {
            this.network.setSelectedIndex(ClientState.getClientState().getInteger("sdialog.selected", 0));
            this.data.update();
            ((ServerListModel)this.list.getModel()).fireChange();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int n) {
    }

    public void setParentVariable(String string) {
    }

    public JComponent getComponent() {
        return this;
    }

    protected class EditServerInfo
    extends APanel {
        protected JTextField description = new JTextField();
        protected JTextField host = new JTextField();
        protected JTextField portRange = new JTextField();
        protected JTextField network = new JTextField();
        protected JCheckBox isSSL = new JCheckBox("Server requires SSL");
        protected JCheckBox isStartup = new JCheckBox("Connect to server on client startup");
        protected JPasswordField password = new JPasswordField();

        protected EditServerInfo() {
        }

        public void setupDialog(Object object) {
            if (object == null) {
                this.setBorder(BorderFactory.createTitledBorder(" Create New Server "));
            } else {
                this.setBorder(BorderFactory.createTitledBorder(" Edit Server Information "));
            }
            LabelGroup labelGroup = new LabelGroup();
            JLabel jLabel = new JLabel(" Description: ");
            JLabel jLabel2 = new JLabel(" Hostname: ");
            JLabel jLabel3 = new JLabel(" Port(s): ");
            JLabel jLabel4 = new JLabel(" Network: ");
            JLabel jLabel5 = new JLabel(" Password: ");
            labelGroup.addLabel(jLabel);
            labelGroup.addLabel(jLabel2);
            labelGroup.addLabel(jLabel3);
            labelGroup.addLabel(jLabel4);
            labelGroup.addLabel(jLabel5);
            this.addComponent(EditServerInfo.mergeComponents(jLabel, this.description, 20));
            this.addComponent(EditServerInfo.mergeComponents(jLabel2, this.host, 20));
            this.addComponent(EditServerInfo.mergeComponents(jLabel3, this.portRange, 100));
            this.addComponent(EditServerInfo.mergeComponents(jLabel4, this.network, 20));
            this.addComponent(this.isSSL);
            this.addComponent(EditServerInfo.mergeComponents(jLabel5, this.password, 20));
            this.addComponent(this.isStartup);
            labelGroup.sync();
            if (object != null) {
                Server server = (Server)object;
                this.description.setText(server.getDescription());
                this.host.setText(server.getHost());
                this.portRange.setText(server.getPorts());
                this.network.setText(server.getNetwork());
                this.isSSL.setSelected(server.isSecure());
                this.isStartup.setSelected(ServerList.this.autoConnect.isValue(server.getHost()));
                this.password.setText(server.getPassword());
            }
        }

        public Object getValue(Object object) {
            Server server = object != null ? (Server)object : new Server();
            if (this.isStartup.isSelected() && !ServerList.this.autoConnect.isValue(this.host.getText())) {
                System.out.println("Adding: " + this.host.getText());
                ServerList.this.autoConnect.add(this.host.getText());
                ServerList.this.autoConnect.save();
            } else if (!this.isStartup.isSelected() && ServerList.this.autoConnect.isValue(this.host.getText())) {
                System.out.println("Removing: " + this.host.getText());
                ServerList.this.autoConnect.remove(this.host.getText());
                ServerList.this.autoConnect.save();
            }
            server.setValues(this.description.getText(), this.host.getText(), this.portRange.getText(), this.network.getText(), this.isSSL.isSelected(), this.password.getText());
            return server;
        }
    }

    protected class NetworkListModel
    extends AbstractListModel
    implements ComboBoxModel {
        protected Object selected;

        protected NetworkListModel() {
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void setSelectedItem(Object object) {
            this.selected = object;
        }

        public void fireChange() {
            this.fireContentsChanged(this, 0, -1);
        }

        public Object getElementAt(int n) {
            return ServerList.this.data.getGroups().get(n);
        }

        public int getSize() {
            return ServerList.this.data.getGroups().size();
        }
    }

    protected class ServerListModel
    extends AbstractListModel
    implements ListCellRenderer {
        protected JLabel cell = new JLabel();

        protected ServerListModel() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Server server = (Server)object;
            if (n < 0 || n > this.getSize()) {
                return this.cell;
            }
            this.cell.setToolTipText(server.getHost() + ":" + server.getPorts());
            Color color = UIManager.getColor("TextField.foreground");
            if (ServerList.this.autoConnect.isValue(server.getHost())) {
                color = Color.blue;
            }
            if (bl) {
                this.cell.setOpaque(true);
                this.cell.setBackground(UIManager.getColor("TextField.selectionBackground"));
                if (color == Color.blue) {
                    this.cell.setForeground(color);
                } else {
                    this.cell.setForeground(UIManager.getColor("TextField.selectionForeground"));
                }
                this.cell.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
                if (server.getNetwork().length() <= 2) {
                    this.cell.setText("Random: " + server.getHost() + ":" + server.getPorts());
                } else if (server.isSecure()) {
                    this.cell.setText(server.getNetwork() + ": " + server.getHost() + ":" + server.getPorts() + " (SSL)");
                } else {
                    this.cell.setText(server.getNetwork() + ": " + server.getHost() + ":" + server.getPorts());
                }
            } else {
                this.cell.setOpaque(false);
                this.cell.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
                this.cell.setForeground(color);
                this.cell.setText(server.getDescription());
            }
            return this.cell;
        }

        public void fireChange() {
            this.fireContentsChanged(this, 0, -1);
        }

        public Object getElementAt(int n) {
            return ServerList.this.data.getServers().get(n);
        }

        public int getSize() {
            return ServerList.this.data.getServers().size();
        }
    }

    protected class ServerEditorDialog
    extends JDialog {
        protected JList alist;

        public String showDialog(Component component) {
            this.setLocationRelativeTo(component);
            this.setVisible(true);
            return "";
        }

        public JList getListbox() {
            return this.alist;
        }

        public ServerEditorDialog(JComponent jComponent) {
            super(JOptionPane.getFrameForComponent(jComponent), "Server Editor", true);
            this.getContentPane().setLayout(new BorderLayout());
            ServerListModel serverListModel = new ServerListModel();
            this.alist = new JList(serverListModel);
            this.alist.setCellRenderer(serverListModel);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)new JScrollPane(this.alist, 22, 30), "Center");
            this.getContentPane().add((Component)jPanel, "Center");
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.setLayout(new FlowLayout());
            JButton jButton = new JButton("Add");
            jButton.setMnemonic('A');
            jToolBar.add(jButton);
            JButton jButton2 = new JButton("Edit");
            jButton2.setMnemonic('E');
            jToolBar.add(jButton2);
            JButton jButton3 = new JButton("Remove");
            jButton3.setMnemonic('R');
            jToolBar.add(jButton3);
            jToolBar.addSeparator();
            JButton jButton4 = new JButton("Sort");
            jButton4.setMnemonic('S');
            jToolBar.add(jButton4);
            jToolBar.addSeparator();
            JButton jButton5 = new JButton("Close");
            jButton5.setMnemonic('C');
            jToolBar.add(jButton5);
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EditServerInfo editServerInfo = new EditServerInfo();
                    editServerInfo.setupDialog(ServerEditorDialog.this.alist.getSelectedValue());
                    ADialog aDialog = new ADialog(((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.component, "Edit Server", editServerInfo, ServerEditorDialog.this.alist.getSelectedValue());
                    aDialog.setSize(new Dimension(330, 280));
                    if (aDialog.showDialog(((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.component) != null) {
                        ((ServerListModel)ServerEditorDialog.this.alist.getModel()).fireChange();
                    }
                }
            });
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EditServerInfo editServerInfo = new EditServerInfo();
                    editServerInfo.setupDialog(null);
                    ADialog aDialog = new ADialog(((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.component, "New Server", editServerInfo, null);
                    aDialog.setSize(new Dimension(330, 280));
                    Server server = (Server)aDialog.showDialog(((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.component);
                    if (server != null) {
                        ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.addServer(server);
                        ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.update();
                        ((ServerListModel)ServerEditorDialog.this.alist.getModel()).fireChange();
                    }
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ServerEditorDialog.this.alist.getSelectedValue() != null) {
                        ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.removeServer((Server)ServerEditorDialog.this.alist.getSelectedValue());
                        ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.update();
                        ((ServerListModel)ServerEditorDialog.this.alist.getModel()).fireChange();
                    }
                }
            });
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.sort();
                    ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.update();
                    ((ServerListModel)ServerEditorDialog.this.alist.getModel()).fireChange();
                }
            });
            jButton5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerEditorDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)jToolBar, "South");
            this.setSize(400, 200);
        }
    }
}

