/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import rero.dck.DContainer;
import rero.dck.DItem;
import rero.dck.DParent;
import rero.dck.DTab;

public class TabbedInput
extends JPanel
implements DItem {
    protected LinkedList items = new LinkedList();
    protected JTabbedPane tabs;

    public TabbedInput() {
        this.setLayout(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.add((Component)this.tabs, "Center");
    }

    public void addTab(DTab dTab) {
        this.tabs.addTab(dTab.getTitle(), null, dTab.getDialog(), dTab.getDescription());
        this.items.add(dTab);
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, (int)super.getPreferredSize().getHeight());
    }

    public void setEnabled(boolean bl) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            ((DContainer)iterator.next()).setEnabled(bl);
        }
        this.tabs.setEnabled(bl);
    }

    public void save() {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            ((DContainer)iterator.next()).save();
        }
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int n) {
    }

    public void setParent(DParent dParent) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            ((DContainer)iterator.next()).setParent(dParent);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        int n = 0;
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            DTab dTab = (DTab)iterator.next();
            dTab.refresh();
            this.tabs.setEnabledAt(n, dTab.isEnabled());
            dTab.setEnabled(dTab.isEnabled());
            ++n;
        }
    }
}

