/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs.server;

import java.util.regex.Pattern;
import rero.util.StringParser;

public class Server
implements Comparable {
    protected static Pattern isServerPassword = Pattern.compile("(\\S)\\S*=(.*)SERVER:(.*):(.*):(.*)GROUP:(.*)");
    protected static Pattern isServerNormal = Pattern.compile("(\\S)\\S*=(.*)SERVER:(.*):(.*)GROUP:(.*)");
    protected String description;
    protected String host;
    protected String portRange;
    protected String network;
    protected boolean isSSL;
    protected String password;
    protected String compare;

    public void setValues(String string, String string2, String string3, String string4, boolean bl, String string5) {
        this.description = string;
        this.host = string2;
        this.portRange = string3;
        this.network = string4;
        this.isSSL = bl;
        this.password = string5;
        this.compare = string4.toUpperCase() + this.host.toUpperCase();
    }

    public Server() {
    }

    public Server(String string, String string2, String string3, String string4, boolean bl, String string5) {
        this.setValues(string, string2, string3, string4, bl, string5);
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean isRandom() {
        return this.getNetwork() == null || this.getNetwork().length() <= 2;
    }

    public String getCompare() {
        return this.compare;
    }

    public int compareTo(Object object) {
        Server server = (Server)object;
        return this.getCompare().compareTo(server.getCompare());
    }

    public String getPassword() {
        return this.password;
    }

    public String getPorts() {
        return this.portRange;
    }

    public String getHost() {
        return this.host;
    }

    public String getConnectPort() {
        String string = this.portRange;
        if (string.indexOf("-") > -1) {
            string = string.substring(0, string.indexOf("-"));
        }
        if (string.indexOf(",") > -1) {
            string = string.substring(0, string.indexOf(","));
        }
        return string.trim();
    }

    public boolean isSecure() {
        return this.isSSL;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getCommand() {
        StringBuffer stringBuffer = new StringBuffer("/server ");
        if (this.isSecure()) {
            stringBuffer.append("-ssl ");
        }
        if (this.getPassword() != null && this.getPassword().length() > 0) {
            stringBuffer.append("-pass ");
            stringBuffer.append(this.getPassword());
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.getHost());
        stringBuffer.append(" ");
        stringBuffer.append(this.getConnectPort());
        return stringBuffer.toString();
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSSL) {
            stringBuffer.append('s');
        } else {
            stringBuffer.append('n');
        }
        stringBuffer.append(n);
        stringBuffer.append('=');
        stringBuffer.append(this.description);
        stringBuffer.append("SERVER:");
        stringBuffer.append(this.host);
        stringBuffer.append(":");
        stringBuffer.append(this.portRange);
        if (this.password != null && this.password.length() > 0) {
            stringBuffer.append(":");
            stringBuffer.append(this.password);
        }
        stringBuffer.append("GROUP:");
        stringBuffer.append(this.network);
        return stringBuffer.toString();
    }

    public static Server decode(String string) {
        StringParser stringParser = new StringParser(string, isServerPassword);
        if (stringParser.matches()) {
            String[] stringArray = stringParser.getParsedStrings();
            boolean bl = stringArray[0].charAt(0) == 's';
            return new Server(stringArray[1], stringArray[2], stringArray[3], stringArray[5], bl, stringArray[4]);
        }
        stringParser = new StringParser(string, isServerNormal);
        if (stringParser.matches()) {
            String[] stringArray = stringParser.getParsedStrings();
            boolean bl = stringArray[0].charAt(0) == 's';
            return new Server(stringArray[1], stringArray[2], stringArray[3], stringArray[4], bl, null);
        }
        return null;
    }
}

