/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs.server;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import rero.config.ClientState;
import rero.dialogs.server.Server;
import rero.dialogs.server.ServerGroup;

public class ServerData {
    protected static ServerData data = null;
    protected ServerGroup allServers = new ServerGroup("All Servers");
    protected ServerGroup randomServers = new ServerGroup("Random Servers");
    protected TreeMap groups = new TreeMap();
    protected ArrayList groupModel = new ArrayList();
    protected ServerGroup active;

    protected ServerData() {
        this.load();
    }

    public Server getServerByName(String string) {
        return this.allServers.getServerByName(string);
    }

    public static ServerData getServerData() {
        if (data == null) {
            data = new ServerData();
        }
        return data;
    }

    public void setActive(ServerGroup serverGroup) {
        this.active = serverGroup;
        if (this.active == this.allServers || this.active == null) {
            this.buildGroupList();
            return;
        }
        this.active.clear();
        this.groups.clear();
        this.randomServers.clear();
        if (this.active != this.randomServers) {
            this.active = this.getGroup(this.active.getName());
        }
        Iterator iterator = this.allServers.getServers().iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            this.getGroup(server.getNetwork()).addServer(server);
        }
        this.buildGroupList();
    }

    public void update() {
        this.setActive(this.active);
    }

    public ArrayList getGroups() {
        return this.groupModel;
    }

    public ArrayList getAllServers() {
        return this.allServers.getServers();
    }

    public ArrayList getServers() {
        if (this.active != null) {
            return this.active.getServers();
        }
        return this.allServers.getServers();
    }

    public ServerGroup getGroup(String string) {
        if (string.length() <= 2) {
            return this.randomServers;
        }
        ServerGroup serverGroup = (ServerGroup)this.groups.get(string.toUpperCase());
        if (serverGroup == null) {
            serverGroup = new ServerGroup(string);
            this.groups.put(string.toUpperCase(), serverGroup);
        }
        return serverGroup;
    }

    public void addServer(Server server) {
        this.getGroup(server.getNetwork()).addServer(server);
        this.allServers.addServer(server);
    }

    public void sort() {
        Collections.sort(this.allServers.getServers());
    }

    public void removeServer(Server server) {
        this.allServers.removeServer(server);
        this.getGroup(server.getNetwork()).removeServer(server);
    }

    public void buildGroupList() {
        this.groupModel.clear();
        this.groupModel.add(this.allServers);
        this.allServers.setNumber(0);
        this.groupModel.add(this.randomServers);
        this.randomServers.setNumber(1);
        int n = 2;
        Iterator iterator = this.groups.values().iterator();
        while (iterator.hasNext()) {
            ServerGroup serverGroup = (ServerGroup)iterator.next();
            if (!serverGroup.isValid()) continue;
            this.groupModel.add(serverGroup);
            serverGroup.setNumber(n);
            ++n;
        }
    }

    public void load() {
        this.groups.clear();
        this.allServers = new ServerGroup("All Servers");
        this.randomServers = new ServerGroup("Random Servers");
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ClientState.getClientState().getResourceAsStream("servers.ini")));
            String string = bufferedReader.readLine();
            while (string != null) {
                Server server = Server.decode(string);
                if (server != null) {
                    this.addServer(server);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setActive(this.allServers);
        this.buildGroupList();
    }

    public void save() {
        try {
            ClientState.getClientState();
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(ClientState.getFile("servers.ini"), false));
            int n = 0;
            printWriter.println("; Who thinks mIRC sucks?");
            printWriter.println("[servers]");
            Iterator iterator = this.allServers.getServers().iterator();
            while (iterator.hasNext()) {
                Server server = (Server)iterator.next();
                printWriter.println(server.toString(n));
                ++n;
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ServerData serverData = new ServerData();
        serverData.load();
    }
}

