/*
 * Decompiled with CFR 0.152.
 */
package rero.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.SessionManager;
import rero.gui.toolbar.AboutAction;
import rero.gui.toolbar.CascadeAction;
import rero.gui.toolbar.ChatAction;
import rero.gui.toolbar.ConnectAction;
import rero.gui.toolbar.DCCAction;
import rero.gui.toolbar.EvilAction;
import rero.gui.toolbar.HelpAction;
import rero.gui.toolbar.ListAction;
import rero.gui.toolbar.NotifyAction;
import rero.gui.toolbar.NotifyAction2;
import rero.gui.toolbar.OptionsAction;
import rero.gui.toolbar.ScriptAction;
import rero.gui.toolbar.SendAction;
import rero.gui.toolbar.TileAction;
import rero.gui.toolbar.ToolAction;

public class GraphicalToolbar
extends JToolBar {
    public static ImageIcon[] images = new ImageIcon[37];
    protected LinkedList tools = new LinkedList();
    private static GraphicalToolbar toolbar = null;
    private static StateListener state;

    public static void startup() {
        state = new StateListener();
        state.propertyChanged("ui.usetoolbar", "");
        ClientState.getClientState().addClientStateListener("ui.usetoolbar", state);
    }

    public static void stateChanged() {
        if (toolbar != null) {
            toolbar.refresh();
        }
    }

    public void refresh() {
        Iterator iterator = this.tools.iterator();
        while (iterator.hasNext()) {
            ((ToolButton)iterator.next()).displayIcon();
        }
    }

    public GraphicalToolbar() {
        int n;
        ToolAction[] toolActionArray;
        int[] nArray;
        if (ClientState.getClientState().isOption("ui.sdi", ClientDefaults.ui_sdi)) {
            nArray = new int[]{0, -1, 4, 7, -1, 10, -1, 22, 23, 24, -1, 26, 28, -1, 35, 36};
            toolActionArray = new ToolAction[]{new ConnectAction(), null, new OptionsAction(), new ScriptAction(), null, new ListAction(), null, new SendAction(), new ChatAction(), new DCCAction(), null, new NotifyAction(), new NotifyAction2(), null, new HelpAction(), new AboutAction(), new EvilAction()};
        } else {
            nArray = new int[]{0, -1, 4, 7, -1, 10, -1, 22, 23, 24, -1, 26, 28, -1, 31, 32, -1, 35, 36};
            toolActionArray = new ToolAction[]{new ConnectAction(), null, new OptionsAction(), new ScriptAction(), null, new ListAction(), null, new SendAction(), new ChatAction(), new DCCAction(), null, new NotifyAction(), new NotifyAction2(), null, new CascadeAction(), new TileAction(), null, new HelpAction(), new AboutAction(), new EvilAction()};
        }
        BufferedImage bufferedImage = GraphicalToolbar.LoadToolbarImage();
        for (n = 0; n < 37; ++n) {
            GraphicalToolbar.images[n] = new ImageIcon(bufferedImage.getSubimage(n * 16, 0, 16, 16));
        }
        for (n = 0; n < toolActionArray.length; ++n) {
            if (toolActionArray[n] == null) {
                this.addSeparator(new Dimension(12, 12));
                continue;
            }
            ToolButton toolButton = new ToolButton(toolActionArray[n]);
            this.add(toolButton);
            this.tools.add(toolButton);
        }
        this.setFloatable(false);
        this.setBorderPainted(true);
    }

    private static BufferedImage LoadToolbarImage() {
        ImageIcon imageIcon = ClientState.getClientState().getIcon("jirc.toolbar", "toolbar.gif");
        Image image = imageIcon.getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        imageIcon.getImage().flush();
        return bufferedImage;
    }

    private static class ToolButton
    extends JLabel {
        private ImageIcon normal;
        private ImageIcon pressed;
        private ToolAction action;

        public ToolButton(ToolAction toolAction) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.addMouseListener(new Listeners());
            this.action = toolAction;
            this.displayIcon();
        }

        public void displayIcon() {
            this.normal = images[this.action.getIndex()];
            this.pressed = new ImageIcon(GrayFilter.createDisabledImage(this.normal.getImage()));
            this.setToolTipText(this.action.getDescription());
            this.setIcon(this.normal);
        }

        private class Listeners
        extends MouseAdapter {
            private Listeners() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ToolButton.this.action.actionPerformed(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ToolButton.this.setIcon(ToolButton.this.pressed);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ToolButton.this.setIcon(ToolButton.this.normal);
            }
        }
    }

    private static class StateListener
    implements ClientStateListener {
        private StateListener() {
        }

        public void propertyChanged(String string, String string2) {
            if (toolbar != null) {
                SessionManager.getGlobalCapabilities().getFrame().getContentPane().remove(toolbar);
            }
            if (ClientState.getClientState().isOption("ui.usetoolbar", true)) {
                if (toolbar == null) {
                    toolbar = new GraphicalToolbar();
                }
                SessionManager.getGlobalCapabilities().getFrame().getContentPane().add((Component)toolbar, "North");
            }
            if (toolbar != null) {
                SessionManager.getGlobalCapabilities().getFrame().getContentPane().validate();
            }
        }
    }
}

