/*
 * Decompiled with CFR 0.152.
 */
package rero.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import rero.bridges.menu.MenuBridge;
import rero.client.Capabilities;
import rero.client.InternetRelayChatClient;
import rero.client.user.UserHandler;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.dcc.DataDCC;
import rero.gui.ClickableURLHandler;
import rero.gui.UICapabilities;
import rero.gui.mdi.ClientDesktop;
import rero.gui.script.UIScriptBridge;
import rero.gui.sdi.ClientPanel;
import rero.gui.windows.AboutWindow;
import rero.gui.windows.ChannelListDialog;
import rero.gui.windows.ChannelWindow;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;
import rero.gui.windows.DCCListDialog;
import rero.gui.windows.QueryWindow;
import rero.gui.windows.ScriptedListDialog;
import rero.gui.windows.StatusWindow;
import rero.gui.windows.WindowManager;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;

public class IRCSession {
    protected WindowManager desktop;
    protected InternetRelayChatClient client = new InternetRelayChatClient();
    protected StatusWindow status;
    protected HashMap windows;
    protected UserHandler userInput;
    protected UIScriptBridge scriptBridge;
    protected ClientWindowStuff windowListener;
    protected ClickableURLHandler urlListener;
    private DCCListDialog dccListDialog = null;

    public void cleanup() {
        this.getCapabilities().cleanup();
    }

    public Capabilities getCapabilities() {
        return this.client.getCapabilities();
    }

    public void executeCommand(String string) {
        ((UserHandler)this.getCapabilities().getDataStructure("commands")).processCommand(string);
    }

    public IRCSession() {
        this.client.init(new UICapabilities(this));
        this.userInput = (UserHandler)this.client.getCapabilities().getDataStructure("commands");
        if (ClientState.getClientState().isOption("ui.sdi", ClientDefaults.ui_sdi)) {
            this.desktop = new ClientPanel();
        } else {
            this.desktop = new ClientDesktop();
            ((ClientDesktop)this.desktop).addMouseListener(new PopupManager());
        }
        this.windows = new HashMap();
        this.urlListener = new ClickableURLHandler();
        this.urlListener.installCapabilities(this.getCapabilities());
        this.windowListener = new ClientWindowStuff();
        this.scriptBridge = new UIScriptBridge(this);
        this.status = this.createStatusWindow();
        this.scriptBridge.windowCreated(this.status);
        this.status.getDisplay().addClickListener(this.urlListener);
    }

    public boolean isWindow(String string) {
        return this.windows.get(string.toUpperCase()) != null || string.equals("%STATUS%");
    }

    public StatusWindow getWindow(String string) {
        if (string == null || this.windows.get(string.toUpperCase()) == null) {
            return this.status;
        }
        return (StatusWindow)this.windows.get(string.toUpperCase());
    }

    public Collection getAllWindows() {
        return this.desktop.getAllWindows();
    }

    public InternetRelayChatClient getClient() {
        return this.client;
    }

    public StatusWindow getStatusWindow() {
        return this.status;
    }

    public boolean isStatus(StatusWindow statusWindow) {
        return statusWindow == this.status;
    }

    public WindowManager getDesktop() {
        return this.desktop;
    }

    public StatusWindow getActiveWindow() {
        StatusWindow statusWindow = this.desktop.getActiveWindow();
        if (statusWindow == null || !statusWindow.isLegalWindow()) {
            return this.getStatusWindow();
        }
        return statusWindow;
    }

    public StatusWindow getRealActiveWindow() {
        return this.desktop.getActiveWindow();
    }

    public void createAboutWindow() {
        AboutWindow aboutWindow = new AboutWindow();
        this.desktop.addWindow(aboutWindow, true);
        Thread thread = new Thread(aboutWindow);
        thread.start();
    }

    public void renameWindow(String string, String string2) {
        StatusWindow statusWindow = (StatusWindow)this.windows.get(string.toUpperCase());
        StatusWindow statusWindow2 = (StatusWindow)this.windows.get(string2.toUpperCase());
        if (statusWindow != null && statusWindow2 == null) {
            this.windows.remove(string.toUpperCase());
            this.windows.put(string2.toUpperCase(), statusWindow);
            statusWindow.setName(string2);
        }
    }

    public void createDCCWindow() {
        if (this.dccListDialog == null) {
            this.dccListDialog = new DCCListDialog();
            this.dccListDialog.installCapabilities(this.client.getCapabilities());
            this.desktop.addWindow(this.dccListDialog, true);
            this.windows.put(this.dccListDialog.getName().toUpperCase(), this.dccListDialog);
            this.scriptBridge.windowCreated(this.dccListDialog);
            this.dccListDialog.getWindow().addWindowListener(this.windowListener);
        } else if (!this.dccListDialog.isOpen()) {
            this.desktop.addWindow(this.dccListDialog, true);
            this.windows.put(this.dccListDialog.getName().toUpperCase(), this.dccListDialog);
            this.scriptBridge.windowCreated(this.dccListDialog);
            this.dccListDialog.getWindow().addWindowListener(this.windowListener);
        }
    }

    public ScriptedListDialog createSortedWindow(String string, String string2, Object object, LinkedList linkedList) {
        ScriptedListDialog scriptedListDialog = new ScriptedListDialog(string, string2, object, linkedList);
        scriptedListDialog.installCapabilities(this.client.getCapabilities());
        this.desktop.addWindow(scriptedListDialog, false);
        this.windows.put(string.toUpperCase(), scriptedListDialog);
        this.scriptBridge.windowCreated(scriptedListDialog);
        scriptedListDialog.getWindow().addWindowListener(this.windowListener);
        return scriptedListDialog;
    }

    public void createListWindow() {
        ChannelListDialog channelListDialog = new ChannelListDialog();
        channelListDialog.installCapabilities(this.client.getCapabilities());
        this.desktop.addWindow(channelListDialog, true);
        this.windows.put(channelListDialog.getName().toUpperCase(), channelListDialog);
        this.scriptBridge.windowCreated(channelListDialog);
        channelListDialog.getWindow().addWindowListener(this.windowListener);
    }

    public StatusWindow createStatusWindow() {
        StatusWindow statusWindow = new StatusWindow();
        this.desktop.addWindow(statusWindow, true);
        statusWindow.getInput().addInputListener(this.userInput);
        statusWindow.installCapabilities(this.client.getCapabilities());
        return statusWindow;
    }

    public QueryWindow createQueryWindow(String string, boolean bl) {
        QueryWindow queryWindow = new QueryWindow(string);
        this.desktop.addWindow(queryWindow, bl);
        queryWindow.getInput().addInputListener(this.userInput);
        queryWindow.installCapabilities(this.client.getCapabilities());
        this.windows.put(string.toUpperCase(), queryWindow);
        this.scriptBridge.windowCreated(queryWindow);
        queryWindow.getDisplay().addClickListener(this.urlListener);
        queryWindow.getWindow().addWindowListener(this.windowListener);
        return queryWindow;
    }

    public ChannelWindow createChannelWindow(Channel channel) {
        ChannelWindow channelWindow = new ChannelWindow(channel);
        this.desktop.addWindow(channelWindow, true);
        channelWindow.getInput().addInputListener(this.userInput);
        channelWindow.installCapabilities(this.client.getCapabilities());
        this.windows.put(channel.getName().toUpperCase(), channelWindow);
        this.scriptBridge.windowCreated(channelWindow);
        channelWindow.getDisplay().addClickListener(this.urlListener);
        channelWindow.getWindow().addWindowListener(this.windowListener);
        return channelWindow;
    }

    public StatusWindow resolveClientWindow(ClientWindow clientWindow) {
        Iterator iterator = this.windows.values().iterator();
        while (iterator.hasNext()) {
            StatusWindow statusWindow = (StatusWindow)iterator.next();
            if (statusWindow.getWindow() != clientWindow) continue;
            return statusWindow;
        }
        return this.status;
    }

    public void postProcessWindow(StatusWindow statusWindow) {
        if (statusWindow instanceof ChannelWindow) {
            InternalDataList internalDataList;
            if (ClientState.getClientState().isOption("auto.part", true) && (internalDataList = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation")).getChannel(statusWindow.getName()) != null) {
                this.getCapabilities().sendln("PART " + statusWindow.getName());
            }
        } else if (statusWindow.getName().charAt(0) == '=' && statusWindow.isLegalWindow() && ClientState.getClientState().isOption("auto.chatclose", true)) {
            DataDCC dataDCC = (DataDCC)this.getCapabilities().getDataStructure("dcc");
            dataDCC.closeChat(statusWindow.getName().substring(1, statusWindow.getName().length()));
        }
    }

    protected void finalize() {
        System.out.println("FINALIZING IRC SESSION y0");
    }

    protected class PopupManager
    extends MouseAdapter {
        protected PopupManager() {
        }

        public void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MenuBridge menuBridge = (MenuBridge)IRCSession.this.client.getCapabilities().getDataStructure("menuBridge");
                JPopupMenu jPopupMenu = menuBridge.getPopupMenu("background", null);
                if (jPopupMenu == null) {
                    return;
                }
                jPopupMenu.show((JComponent)mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }
    }

    protected class ClientWindowStuff
    implements ClientWindowListener {
        protected ClientWindowStuff() {
        }

        public void onActive(ClientWindowEvent clientWindowEvent) {
        }

        public void onOpen(ClientWindowEvent clientWindowEvent) {
        }

        public void onInactive(ClientWindowEvent clientWindowEvent) {
        }

        public void onMinimize(ClientWindowEvent clientWindowEvent) {
        }

        public void onClose(ClientWindowEvent clientWindowEvent) {
            ClientWindow clientWindow = clientWindowEvent.getSource();
            Iterator iterator = IRCSession.this.windows.values().iterator();
            while (iterator.hasNext()) {
                StatusWindow statusWindow = (StatusWindow)iterator.next();
                if (statusWindow.getWindow() != clientWindow) continue;
                IRCSession.this.postProcessWindow(statusWindow);
                iterator.remove();
                return;
            }
        }
    }
}

