/*
 * Decompiled with CFR 0.152.
 */
package rero.gui;

import java.awt.KeyEventDispatcher;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import rero.bridges.bind.BindEnvironment;
import rero.gui.IRCSession;
import rero.gui.SessionManager;

public class KeyBindings
implements KeyEventDispatcher {
    public static boolean is_dialog_active = false;
    protected SessionManager session;
    protected HashMap binds;

    public KeyBindings(SessionManager sessionManager) {
        this.session = sessionManager;
        this.binds = new HashMap();
    }

    public void removeSession(IRCSession iRCSession) {
        Iterator iterator = this.binds.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k != iRCSession) continue;
            iterator.remove();
        }
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() != 401 || is_dialog_active) {
            return false;
        }
        BindEnvironment bindEnvironment = (BindEnvironment)this.binds.get(this.session.getActiveSession());
        if (bindEnvironment == null) {
            this.binds.put(this.session.getActiveSession(), this.session.getActiveSession().getCapabilities().getDataStructure("bindBridge"));
            bindEnvironment = (BindEnvironment)this.binds.get(this.session.getActiveSession());
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (keyEvent.getModifiers() != 0) {
            stringBuffer.append(KeyBindings.getKeyModifiers(keyEvent));
        }
        stringBuffer.append(KeyBindings.getKeyText(keyEvent));
        if (bindEnvironment != null && bindEnvironment.isBound(stringBuffer.toString())) {
            SwingUtilities.invokeLater(new ExecuteBind(stringBuffer.toString(), bindEnvironment));
            keyEvent.consume();
            return true;
        }
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 9) {
            keyEvent.consume();
            return true;
        }
        return false;
    }

    private static String getKeyModifiers(KeyEvent keyEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        if (keyEvent.isShiftDown()) {
            stringBuffer.append("Shift+");
        }
        if (keyEvent.isControlDown()) {
            stringBuffer.append("Ctrl+");
        }
        if (keyEvent.isAltDown()) {
            stringBuffer.append("Alt+");
        }
        if (keyEvent.isMetaDown()) {
            stringBuffer.append("Meta+");
        }
        return stringBuffer.toString();
    }

    private static String getKeyText(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 30: {
                return "Accept";
            }
            case 192: {
                return "Back_Quote";
            }
            case 8: {
                return "Backspace";
            }
            case 20: {
                return "Caps_Lock";
            }
            case 12: {
                return "Clear";
            }
            case 28: {
                return "Convert";
            }
            case 127: {
                return "Delete";
            }
            case 40: {
                return "Down";
            }
            case 35: {
                return "End";
            }
            case 10: {
                return "Enter";
            }
            case 27: {
                return "Escape";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 24: {
                return "Final";
            }
            case 156: {
                return "Help";
            }
            case 36: {
                return "Home";
            }
            case 155: {
                return "Insert";
            }
            case 37: {
                return "Left";
            }
            case 144: {
                return "Num_Lock";
            }
            case 106: {
                return "NumPad_*";
            }
            case 521: {
                return "NumPad_+";
            }
            case 44: {
                return "NumPad_,";
            }
            case 109: {
                return "NumPad_-";
            }
            case 46: {
                return "Period";
            }
            case 47: {
                return "NumPad_/";
            }
            case 34: {
                return "Page_Down";
            }
            case 33: {
                return "Page_Up";
            }
            case 19: {
                return "Pause";
            }
            case 154: {
                return "Print_Screen";
            }
            case 222: {
                return "Quote";
            }
            case 39: {
                return "Right";
            }
            case 145: {
                return "Scroll_Lock";
            }
            case 32: {
                return "Space";
            }
            case 9: {
                return "Tab";
            }
            case 38: {
                return "Up";
            }
        }
        return KeyEvent.getKeyText(keyEvent.getKeyCode());
    }

    private static class ExecuteBind
    implements Runnable {
        private BindEnvironment bind;
        private String desc;

        public ExecuteBind(String string, BindEnvironment bindEnvironment) {
            this.desc = string;
            this.bind = bindEnvironment;
        }

        public void run() {
            this.bind.processEvent(this.desc);
        }
    }
}

