/*
 * Decompiled with CFR 0.152.
 */
package rero.gui;

import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rero.bridges.menu.MenuBridge;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.config.StringList;
import rero.dialogs.server.Server;
import rero.dialogs.server.ServerData;
import rero.gui.GlobalCapabilities;
import rero.gui.GraphicalToolbar;
import rero.gui.IRCSession;
import rero.gui.KeyBindings;
import rero.gui.toolkit.MinimalTabUI;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;
import rero.net.SocketEvent;
import rero.net.interfaces.SocketStatusListener;
import rero.test.QuickConnect;
import rero.util.ClientUtils;

public class SessionManager
extends JTabbedPane
implements ClientWindowListener,
SocketStatusListener,
ChangeListener,
ClientStateListener {
    protected HashMap sessions = new HashMap();
    protected IRCSession active = null;
    protected JFrame frame = null;
    protected MenuBridge bridge = null;
    protected PopupManager popups = null;
    protected KeyBindings keyb = null;
    protected String lastscript = "";
    protected long lastref = 0L;
    protected static GlobalCapabilities global;
    protected HashMap switchEventHashMap = new HashMap();

    public static GlobalCapabilities getGlobalCapabilities() {
        return global;
    }

    public void propertyChanged(String string, String string2) {
        this.bridge = (MenuBridge)this.getActiveSession().getCapabilities().getDataStructure("menuBridge");
        ClientUtils.invokeLater(new Runnable(){

            public void run() {
                if (ClientState.getClientState().isOption("ui.showbar", true)) {
                    JMenuBar jMenuBar = new JMenuBar();
                    SessionManager.this.bridge.installMenubar(jMenuBar);
                    SessionManager.this.frame.setJMenuBar(jMenuBar);
                } else {
                    SessionManager.this.frame.setJMenuBar(null);
                }
                SessionManager.this.frame.validate();
            }
        });
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.active = this.getSession(this.getSelectedComponent());
        if (this.getActiveSession() != null) {
            this.propertyChanged(null, null);
            GraphicalToolbar.stateChanged();
            this.getActiveSession().getCapabilities().dispatchEvent(this.switchEventHashMap);
        }
    }

    public SessionManager(JFrame jFrame) {
        this.switchEventHashMap.put("$event", "session");
        this.setTabPlacement(3);
        global = new GlobalCapabilities(this);
        this.keyb = new KeyBindings(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyb);
        this.addChangeListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!ClientState.getClientState().isOption("ui.showtabs", true)) {
                    SessionManager.this.setUI(new MinimalTabUI());
                }
                StringList stringList = ClientState.getClientState().getStringList("auto.connect");
                if (QuickConnect.IsQuickConnect()) {
                    SessionManager.this.addSession();
                    SessionManager.this.getSession(SessionManager.this.getComponentAt(0)).executeCommand(QuickConnect.GetInformation().getConnectCommand());
                } else if (stringList.getList().size() == 0) {
                    SessionManager.this.addSession();
                } else {
                    ServerData serverData = ServerData.getServerData();
                    int n = 0;
                    Iterator iterator = stringList.getList().iterator();
                    while (iterator.hasNext()) {
                        Server server = serverData.getServerByName(iterator.next().toString());
                        if (server == null) continue;
                        SessionManager.this.addSession();
                        SessionManager.this.getSession(SessionManager.this.getComponentAt(n)).executeCommand(server.getCommand());
                        ++n;
                    }
                }
                GraphicalToolbar.startup();
            }
        });
        this.frame = jFrame;
        if (ClientState.getClientState().isOption("ui.showbar", true)) {
            this.frame.setJMenuBar(new JMenuBar());
        }
        if (this.getMouseListeners().length > 0) {
            this.removeMouseListener(this.getMouseListeners()[0]);
        }
        this.popups = new PopupManager();
        this.addMouseListener(this.popups);
        ClientState.getClientState().addClientStateListener("loaded.scripts", this);
        ClientState.getClientState().addClientStateListener("ui.showbar", this);
    }

    public IRCSession getActiveSession() {
        return this.active;
    }

    public IRCSession getSpecificSession(int n) {
        return this.getSession(this.getComponentAt(n));
    }

    public void addSession() {
        IRCSession iRCSession;
        this.active = iRCSession = new IRCSession();
        this.sessions.put(iRCSession.getStatusWindow().getWindow(), iRCSession);
        this.sessions.put(iRCSession.getCapabilities().getSocketConnection(), iRCSession);
        this.sessions.put(iRCSession.getCapabilities(), iRCSession);
        this.sessions.put(iRCSession.getDesktop(), iRCSession);
        iRCSession.getStatusWindow().getWindow().addWindowListener(this);
        iRCSession.getCapabilities().getSocketConnection().addSocketStatusListener(this);
        this.setSelectedComponent(this.add("not connected", iRCSession.getDesktop()));
        iRCSession.getClient().post();
        this.propertyChanged(null, null);
        this.revalidate();
        if (ClientState.getClientState().getString("user.nick", null) == null && !QuickConnect.IsQuickConnect()) {
            SessionManager.getGlobalCapabilities().showOptionDialog(null);
            iRCSession.getStatusWindow().getInput().requestFocus();
        }
    }

    public IRCSession getSession(Object object) {
        return (IRCSession)this.sessions.get(object);
    }

    public int getIndexFor(Object object) {
        IRCSession iRCSession = this.getSession(object);
        if (iRCSession == null) {
            return -1;
        }
        int n = this.indexOfComponent(iRCSession.getDesktop());
        if (n > this.getTabCount()) {
            return -1;
        }
        return n;
    }

    public void removeSession(IRCSession iRCSession) {
        Iterator iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v != iRCSession) continue;
            iterator.remove();
        }
        long l = Runtime.getRuntime().freeMemory();
        this.remove(iRCSession.getDesktop());
        this.keyb.removeSession(iRCSession);
        iRCSession.cleanup();
        this.revalidate();
        System.gc();
        l = Runtime.getRuntime().freeMemory() - l;
        System.out.println("Freed a total of " + ClientUtils.formatBytes(l));
        if (this.getTabCount() <= 0) {
            this.addSession();
        }
        if (this.active == iRCSession) {
            this.stateChanged(null);
        }
    }

    public void onClose(ClientWindowEvent clientWindowEvent) {
        IRCSession iRCSession = this.getSession(clientWindowEvent.getSource());
        this.removeSession(iRCSession);
        if (iRCSession.getCapabilities().isConnected()) {
            iRCSession.getCapabilities().sendln("QUIT :Hey! Where'd my controlling terminal go?");
            iRCSession.getCapabilities().getSocketConnection().disconnect();
        }
    }

    public void onActive(ClientWindowEvent clientWindowEvent) {
    }

    public void onInactive(ClientWindowEvent clientWindowEvent) {
    }

    public void onMinimize(ClientWindowEvent clientWindowEvent) {
    }

    public void onOpen(ClientWindowEvent clientWindowEvent) {
    }

    public void setTabTitle(Object object, String string) {
        this.setTitleAt(this.getIndexFor(object), string);
    }

    public void socketStatusChanged(SocketEvent socketEvent) {
        if (socketEvent.data.isConnected) {
            if (this.getIndexFor(socketEvent.socket) > -1) {
                this.setTitleAt(this.getIndexFor(socketEvent.socket), socketEvent.data.hostname);
            }
        } else if (this.getIndexFor(socketEvent.socket) > -1) {
            this.setTitleAt(this.getIndexFor(socketEvent.socket), "disconnected");
        }
        GraphicalToolbar.stateChanged();
    }

    public IRCSession getSessionAt(Point point) {
        if (this.indexAtLocation((int)point.getX(), (int)point.getY()) < 0) {
            return null;
        }
        return this.getSession(this.getComponentAt(this.indexAtLocation((int)point.getX(), (int)point.getY())));
    }

    protected class PopupManager
    extends MouseAdapter {
        protected PopupManager() {
        }

        public void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                IRCSession iRCSession = SessionManager.this.getSessionAt(mouseEvent.getPoint());
                if (iRCSession == null) {
                    return;
                }
                SessionManager.this.bridge = (MenuBridge)iRCSession.getCapabilities().getDataStructure("menuBridge");
                JPopupMenu jPopupMenu = SessionManager.this.bridge.getPopupMenu("tab", null);
                if (jPopupMenu == null) {
                    return;
                }
                jPopupMenu.show((JComponent)mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
                return;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            this.maybeShowPopup(mouseEvent);
            if (mouseEvent.getButton() == 1 && (n = SessionManager.this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY())) > -1) {
                SessionManager.this.setSelectedIndex(n);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

