/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.background;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.background.BackgroundProperties;
import rero.gui.background.BackgroundUtil;

public class BackgroundDesktop
extends JPanel
implements ClientStateListener {
    protected BackgroundProperties bgProperties;
    protected JComponent desktop;

    public BackgroundDesktop(JComponent jComponent) {
        this.desktop = jComponent;
        if (this.bgProperties == null) {
            this.bgProperties = new BackgroundProperties("desktop", 0);
        }
        ClientState.getClientState().addClientStateListener("desktop", this);
    }

    public Dimension getSize() {
        return this.desktop.getSize();
    }

    public void propertyChanged(String string, String string2) {
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = graphics.getClipBounds().x;
        int n2 = graphics.getClipBounds().y;
        int n3 = graphics.getClipBounds().width;
        int n4 = graphics.getClipBounds().height;
        switch (this.bgProperties.getType()) {
            case 0: {
                break;
            }
            case 1: {
                graphics.setColor(this.bgProperties.getColor());
                graphics.fillRect(n, n2, n3, n4);
                this.paintChildren(graphics);
                break;
            }
            case 3: {
                BackgroundUtil.drawBackground(this, graphics, this.bgProperties);
                this.paintChildren(graphics);
            }
        }
    }
}

