/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.background;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.background.BackgroundUtil;

public class BackgroundProperties
implements ClientStateListener {
    protected String type;
    protected int bgType;
    protected int bgStyle;
    protected Image image;
    protected Image transform;
    protected String name;
    protected Color bgColor;
    protected float bgTint;
    protected boolean isRelative;

    public boolean isRelative() {
        return this.isRelative;
    }

    public int getType() {
        return this.bgType;
    }

    public int getStyle() {
        return this.bgStyle;
    }

    public Color getColor() {
        return this.bgColor;
    }

    public float getTint() {
        return this.bgTint;
    }

    public BackgroundProperties(String string, int n) {
        this(string, Color.white, n);
    }

    public BackgroundProperties(String string, Color color, int n) {
        this(string, color, n, 0, 0.5f);
    }

    public BackgroundProperties(String string, Color color, int n, int n2, float f) {
        this.type = string;
        ClientState.getClientState().addClientStateListener(this.type, this);
        this.init(color, n, n2, f);
    }

    public void propertyChanged(String string, String string2) {
        this.init(this.bgColor, this.bgType, this.bgStyle, this.bgTint);
    }

    public void init(Color color, int n, int n2, float f) {
        String string = ClientState.getClientState().getString(this.type + ".image", "background.jpg");
        int n3 = ClientState.getClientState().getInteger(this.type + ".bgtype", n);
        Color color2 = ClientState.getClientState().getColor(this.type + ".color", color);
        float f2 = ClientState.getClientState().getFloat(this.type + ".tint", f);
        int n4 = ClientState.getClientState().getInteger(this.type + ".bgstyle", n2);
        boolean bl = ClientState.getClientState().isOption(this.type + ".relative", false);
        if (!string.equals(this.name) || this.bgColor == null || this.bgType != n3 || !this.bgColor.equals(color2) || this.bgTint != f2 || this.bgStyle != n4 || this.isRelative != bl) {
            this.name = string;
            this.bgType = n3;
            this.bgColor = color2;
            this.bgTint = f2;
            this.bgStyle = n4;
            this.isRelative = bl;
            this.image = null;
            this.transform = null;
        }
    }

    public Image getImage(Component component) {
        if (this.image == null) {
            String string = ClientState.getClientState().getString(this.type + ".image", "background.jpg");
            this.image = BackgroundUtil.getManagedImage(component, string, this.bgTint, this.bgColor);
        }
        return this.image;
    }

    public Image getTransformedImage() {
        return this.transform;
    }

    public void setTransformedImage(Image image) {
        this.transform = image;
    }
}

