/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.mdi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.KeyBindings;
import rero.gui.background.BackgroundDesktop;
import rero.gui.mdi.ClientInternalWindow;
import rero.gui.toolkit.OrientedToolBar;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;
import rero.gui.windows.StatusWindow;
import rero.gui.windows.SwitchBarOptions;
import rero.gui.windows.WindowManager;
import rero.util.ClientUtils;

public class ClientDesktop
extends WindowManager
implements ClientWindowListener,
ClientStateListener {
    protected JDesktopPane desktop;

    public void init() {
        this.desktop = new JDesktopPane();
        this.switchbar = new OrientedToolBar();
        this.setLayout(new BorderLayout());
        this.add((Component)this.desktop, "Center");
        this.switchOptions = new SwitchBarOptions(this, this.switchbar);
        this.windowMap = new HashMap();
        this.windows = new LinkedList();
        this.desktop.setDesktopManager(new MyModifiedDesktopManager());
        MantainActiveFocus mantainActiveFocus = new MantainActiveFocus(this);
        BackgroundDesktop backgroundDesktop = new BackgroundDesktop(this.desktop);
        backgroundDesktop.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.desktop.add((Component)backgroundDesktop, new Integer(Integer.MIN_VALUE));
    }

    public void addWindow(StatusWindow statusWindow, boolean bl) {
        ClientInternalWindow clientInternalWindow = new ClientInternalWindow();
        statusWindow.init(clientInternalWindow);
        Rectangle rectangle = ClientState.getClientState().getBounds(statusWindow.getWindowType() + ".size", this.desktop.getSize(), new Dimension(480, 300));
        clientInternalWindow.setBounds(rectangle);
        this.windowMap.put(statusWindow.getWindow(), statusWindow);
        this.windowMap.put(statusWindow.getButton(), statusWindow);
        statusWindow.getWindow().addWindowListener(this);
        statusWindow.getButton().addActionListener(this);
        this.addToSwitchbar(statusWindow);
        this.desktop.add((JInternalFrame)((Object)statusWindow.getWindow()));
        if (!bl) {
            clientInternalWindow.setVisible(false);
        } else {
            statusWindow.getWindow().show();
        }
        ClientUtils.invokeLater(new Runnable(){

            public void run() {
                if (ClientDesktop.this.desktop.getSelectedFrame() != null && !ClientDesktop.this.desktop.getSelectedFrame().isSelected()) {
                    try {
                        ClientDesktop.this.refreshFocus(ClientDesktop.this.desktop.getSelectedFrame());
                        ClientDesktop.this.desktop.getSelectedFrame().setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    ClientDesktop.this.desktop.repaint();
                }
            }
        });
    }

    public void onActive(ClientWindowEvent clientWindowEvent) {
        StatusWindow statusWindow = this.getWindowFor(clientWindowEvent.getSource());
        this.doActivate(statusWindow);
    }

    public void onInactive(ClientWindowEvent clientWindowEvent) {
        this.doDeactivate(this.getWindowFor(clientWindowEvent.getSource()));
    }

    public void onMinimize(ClientWindowEvent clientWindowEvent) {
        boolean bl = clientWindowEvent.getSource().isSelected();
        this.doDeactivate(this.getWindowFor(clientWindowEvent.getSource()));
        if (bl) {
            int n = this.windows.indexOf(this.getWindowFor(clientWindowEvent.getSource()));
            this.newActive(n, false);
            this.refreshFocus(this.desktop.getSelectedFrame());
        }
    }

    public void onOpen(ClientWindowEvent clientWindowEvent) {
        StatusWindow statusWindow = this.getWindowFor(clientWindowEvent.getSource());
        try {
            JInternalFrame jInternalFrame = this.desktop.getSelectedFrame();
            if (jInternalFrame != null && jInternalFrame.isMaximum()) {
                this.doActivate(statusWindow);
                ((JInternalFrame)((Object)clientWindowEvent.getSource())).setMaximum(true);
            } else {
                this.doActivate(statusWindow);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onClose(ClientWindowEvent clientWindowEvent) {
        int n = this.windows.indexOf(this.getWindowFor(clientWindowEvent.getSource()));
        boolean bl = clientWindowEvent.getSource().isSelected();
        ClientWindow clientWindow = clientWindowEvent.getSource();
        StatusWindow statusWindow = (StatusWindow)this.windowMap.get(clientWindow);
        this.saveBounds(statusWindow);
        this.switchbar.remove(statusWindow.getButton());
        this.windowMap.remove(clientWindow);
        this.windowMap.remove(statusWindow.getButton());
        this.windowMap.remove(statusWindow.getWindow());
        this.windows.remove(statusWindow);
        this.switchbar.validate();
        this.switchbar.repaint();
        if (this.desktop.getSelectedFrame() == null) {
            this.newActive(n, true);
            this.refreshFocus(this.desktop.getSelectedFrame());
        }
    }

    public StatusWindow getActiveWindow() {
        JInternalFrame jInternalFrame = this.desktop.getSelectedFrame();
        return this.getWindowFor(jInternalFrame);
    }

    protected void doActivate(StatusWindow statusWindow) {
        try {
            JInternalFrame jInternalFrame = (JInternalFrame)((Object)statusWindow.getWindow());
            if (!((ClientInternalWindow)statusWindow.getWindow()).isOpen()) {
                statusWindow.getWindow().show();
            }
            if (!jInternalFrame.isSelected()) {
                JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
                for (int i = 0; i < jInternalFrameArray.length; ++i) {
                    if (!jInternalFrameArray[i].isSelected()) continue;
                    jInternalFrameArray[i].setSelected(false);
                }
            }
            if (jInternalFrame.isIcon()) {
                jInternalFrame.setIcon(false);
            }
            this.desktop.setSelectedFrame(jInternalFrame);
            statusWindow.getButton().setSelected(true);
            jInternalFrame.setSelected(true);
            if (statusWindow.isLegalWindow()) {
                statusWindow.getInput().requestFocus();
            }
            this.saveBounds(statusWindow);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    private void saveBounds(StatusWindow statusWindow) {
        JInternalFrame jInternalFrame = (JInternalFrame)((Object)statusWindow.getWindow());
        if (statusWindow.getWindow().isMaximum()) {
            ClientState.getClientState().setBounds(statusWindow.getWindowType() + ".size", new Rectangle(0, 0, (int)this.desktop.getSize().getWidth(), (int)this.desktop.getSize().getHeight()));
        } else {
            ClientState.getClientState().setBounds(statusWindow.getWindowType() + ".size", jInternalFrame.getBounds());
        }
    }

    public void refreshFocus(JInternalFrame jInternalFrame) {
        if (jInternalFrame != null && this.isShowing() && this.getWindowFor(jInternalFrame).isLegalWindow() && !KeyBindings.is_dialog_active) {
            this.getWindowFor(jInternalFrame).getInput().requestFocus();
        }
    }

    protected void doDeactivate(StatusWindow statusWindow) {
        JInternalFrame jInternalFrame = (JInternalFrame)((Object)statusWindow.getWindow());
        if (jInternalFrame.isSelected()) {
            try {
                jInternalFrame.setIcon(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        statusWindow.getButton().setSelected(false);
        try {
            jInternalFrame.setSelected(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int totalOpenWindows() {
        int n = 0;
        for (int i = 0; i < this.desktop.getAllFrames().length; ++i) {
            JInternalFrame jInternalFrame = this.desktop.getAllFrames()[i];
            if (jInternalFrame.isIcon()) continue;
            ++n;
        }
        return n;
    }

    public void cascadeWindows() {
        Dimension dimension = this.desktop.getSize();
        int n = dimension.width * 4 / 5;
        int n2 = dimension.height * 2 / 3;
        int n3 = this.totalOpenWindows();
        if (n3 <= 0) {
            return;
        }
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        int n4 = n3 - 1;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            try {
                if (jInternalFrameArray[i].isIcon()) continue;
                try {
                    jInternalFrameArray[i].setMaximum(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jInternalFrameArray[i].setSize(n, n2);
                jInternalFrameArray[i].setLocation(n4 * 20, n4 * 20);
                --n4;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void tileWindows() {
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        int n = this.totalOpenWindows();
        if (n <= 0) {
            return;
        }
        int n2 = (int)Math.sqrt(n);
        int n3 = n / n2;
        if (n % n2 != 0) {
            ++n3;
        }
        Dimension dimension = this.desktop.getSize();
        int n4 = dimension.width / n2;
        int n5 = dimension.height / n3;
        int n6 = 0;
        int n7 = 1;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (jInternalFrameArray[i].isIcon()) continue;
            try {
                jInternalFrameArray[i].setMaximum(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            jInternalFrameArray[i].setSize(new Dimension(n4, n5));
            jInternalFrameArray[i].setLocation((n7 - 1) * n4, n6);
            if (n7 == n2) {
                n7 = 0;
                n6 += n5;
            }
            ++n7;
        }
    }

    private class MantainActiveFocus
    extends ComponentAdapter {
        protected ClientDesktop desktop;

        public MantainActiveFocus(ClientDesktop clientDesktop2) {
            this.desktop = clientDesktop2;
            this.desktop.addComponentListener(this);
        }

        public void componentShown(ComponentEvent componentEvent) {
            JDesktopPane jDesktopPane = this.desktop.desktop;
            if (jDesktopPane.getSelectedFrame() != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            if (!MantainActiveFocus.this.desktop.desktop.getSelectedFrame().isSelected()) {
                                MantainActiveFocus.this.desktop.desktop.getSelectedFrame().setSelected(true);
                            }
                            MantainActiveFocus.this.desktop.refreshFocus(MantainActiveFocus.this.desktop.desktop.getSelectedFrame());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                jDesktopPane.repaint();
            }
        }
    }

    protected class MyModifiedDesktopManager
    extends DefaultDesktopManager {
        protected MyModifiedDesktopManager() {
        }

        public void closeFrame(JInternalFrame jInternalFrame) {
        }

        public void iconifyFrame(JInternalFrame jInternalFrame) {
            boolean bl = jInternalFrame.isSelected();
            jInternalFrame.setVisible(false);
            jInternalFrame.getParent().repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
        }

        public void deiconifyFrame(JInternalFrame jInternalFrame) {
            jInternalFrame.setVisible(true);
        }

        public void dragFrame(JComponent jComponent, int n, int n2) {
            super.dragFrame(jComponent, n, n2);
            if (ClientDesktop.this.isRelative) {
                // empty if block
            }
        }

        public void endDraggingFrame(JComponent jComponent) {
            super.endDraggingFrame(jComponent);
            if (ClientDesktop.this.isRelative) {
                jComponent.repaint();
            }
        }
    }
}

