/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.mdi;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;

public class ClientInternalWindow
extends JInternalFrame
implements ClientWindow,
InternalFrameListener {
    protected LinkedList clisteners = new LinkedList();
    protected ClientWindowEvent cevent = new ClientWindowEvent(this);
    protected boolean isOpen = false;

    public ClientInternalWindow() {
        super("", true, true, true, true);
        this.addInternalFrameListener(this);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.setFrameIcon(imageIcon);
    }

    public void addWindowListener(ClientWindowListener clientWindowListener) {
        this.clisteners.add(clientWindowListener);
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        ListIterator listIterator = this.clisteners.listIterator();
        while (listIterator.hasNext()) {
            ClientWindowListener clientWindowListener = (ClientWindowListener)listIterator.next();
            clientWindowListener.onActive(this.cevent);
        }
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        ListIterator listIterator = this.clisteners.listIterator();
        while (listIterator.hasNext()) {
            ClientWindowListener clientWindowListener = (ClientWindowListener)listIterator.next();
            clientWindowListener.onInactive(this.cevent);
        }
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        ListIterator listIterator = this.clisteners.listIterator();
        while (listIterator.hasNext()) {
            ClientWindowListener clientWindowListener = (ClientWindowListener)listIterator.next();
            clientWindowListener.onClose(this.cevent);
        }
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        ListIterator listIterator = this.clisteners.listIterator();
        while (listIterator.hasNext()) {
            ClientWindowListener clientWindowListener = (ClientWindowListener)listIterator.next();
            clientWindowListener.onMinimize(this.cevent);
        }
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        ListIterator listIterator = this.clisteners.listIterator();
        while (listIterator.hasNext()) {
            ClientWindowListener clientWindowListener = (ClientWindowListener)listIterator.next();
            clientWindowListener.onOpen(this.cevent);
        }
    }

    public void closeWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ClientInternalWindow.this.setClosed(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setMaximum(boolean bl) {
        try {
            super.setMaximum(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setIcon(boolean bl) {
        try {
            super.setIcon(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTitle(String string) {
        this.title = string;
        this.revalidate();
        this.repaint();
    }

    public void show() {
        this.isOpen = true;
        super.show();
    }

    public void activate() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (!ClientInternalWindow.this.isOpen) {
                        ClientInternalWindow.this.show();
                    }
                    ClientInternalWindow.this.setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

