/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.script;

import rero.bridges.event.EventBridge;
import rero.gui.IRCSession;
import rero.gui.script.SessionOperators;
import rero.gui.script.UIOperators;
import rero.gui.script.WindowAreaClickListener;
import rero.gui.script.WindowClickListener;
import rero.gui.script.WindowDataListener;
import rero.gui.script.WindowInputListener;
import rero.gui.script.WindowManagementOperators;
import rero.gui.script.WindowOperators;
import rero.gui.script.WindowStateListener;
import rero.gui.windows.ChannelWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.EmptyWindow;
import rero.gui.windows.StatusWindow;

public class UIScriptBridge {
    protected IRCSession session;
    protected WindowStateListener windowState;
    protected WindowDataListener windowData;
    protected WindowClickListener windowClick;
    protected WindowClickListener windowDoubleClick;
    protected WindowClickListener windowSpecialClick;
    protected WindowInputListener windowInput;
    protected WindowAreaClickListener areaClickListener;
    protected SessionOperators sessionOps;
    protected WindowOperators windowOps;
    protected WindowManagementOperators windowMgmt;
    protected UIOperators interfaceOps;

    public UIScriptBridge(IRCSession iRCSession) {
        this.session = iRCSession;
        EventBridge eventBridge = (EventBridge)this.session.getCapabilities().getDataStructure("eventBridge");
        this.windowState = new WindowStateListener(this.session);
        this.windowState.registerListener(eventBridge);
        this.windowData = new WindowDataListener(this.session.getCapabilities().getUserInterface());
        eventBridge.registerEvent("window", this.windowData);
        this.windowClick = new WindowClickListener();
        eventBridge.registerEvent("click", this.windowClick);
        this.windowDoubleClick = new WindowClickListener();
        eventBridge.registerEvent("dclick", this.windowDoubleClick);
        this.areaClickListener = new WindowAreaClickListener();
        eventBridge.registerEvent("cclick", this.areaClickListener);
        this.windowSpecialClick = new WindowClickListener();
        eventBridge.registerEvent("sclick", this.windowSpecialClick);
        this.windowInput = new WindowInputListener();
        eventBridge.registerEvent("input", this.windowInput);
        this.windowOps = new WindowOperators(this.session);
        this.session.getCapabilities().getScriptCore().addBridge(this.windowOps);
        this.windowMgmt = new WindowManagementOperators(this.session);
        this.session.getCapabilities().getScriptCore().addBridge(this.windowMgmt);
        this.sessionOps = new SessionOperators(this.session);
        this.session.getCapabilities().getScriptCore().addBridge(this.sessionOps);
        this.interfaceOps = new UIOperators(this.session);
        this.session.getCapabilities().getScriptCore().addBridge(this.interfaceOps);
    }

    public void windowCreated(StatusWindow statusWindow) {
        statusWindow.getWindow().addWindowListener(this.windowState);
        if (statusWindow.isLegalWindow()) {
            statusWindow.getDisplay().addClickListener(this.windowClick);
            statusWindow.getDisplay().addClickListener(this.areaClickListener);
            statusWindow.getInput().addInputListener(this.windowInput);
            if (statusWindow instanceof ChannelWindow) {
                ((ChannelWindow)statusWindow).addClickListener(this.windowDoubleClick);
            }
        } else {
            ((EmptyWindow)statusWindow).addClickListener(this.windowSpecialClick);
        }
        this.windowState.onOpen(new ClientWindowEvent(statusWindow.getWindow()));
    }
}

