/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.script;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import javax.swing.JFrame;
import rero.gui.IRCSession;
import rero.gui.SessionManager;
import rero.gui.mdi.ClientDesktop;
import rero.gui.windows.StatusWindow;
import rero.ircfw.InternalDataList;
import rero.util.ClientUtils;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class WindowManagementOperators
implements Function,
Loadable {
    protected IRCSession session;

    public WindowManagementOperators(IRCSession iRCSession) {
        this.session = iRCSession;
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        String[] stringArray = new String[]{"&openWindow", "&closeWindow", "&setWindowState", "&getWindowState", "&activateWindow", "&getActiveWindow", "&getCurrentWindow", "&getWindows", "&tileWindows", "&cascadeWindows"};
        for (int i = 0; i < stringArray.length; ++i) {
            scriptInstance.getScriptEnvironment().getEnvironment().put(stringArray[i], this);
        }
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&openWindow")) {
            String string2 = stack.pop().toString();
            InternalDataList internalDataList = (InternalDataList)this.session.getCapabilities().getDataStructure("clientInformation");
            if (ClientUtils.isChannel(string2)) {
                this.session.getCapabilities().getUserInterface().openChannelWindow(internalDataList.getChannel(string2));
            } else {
                this.session.getCapabilities().getUserInterface().openQueryWindow(string2, stack.isEmpty());
            }
        } else if (string.equals("&closeWindow")) {
            String string3 = stack.pop().toString();
            if (this.session.isWindow(string3)) {
                this.session.getWindow(string3).getWindow().closeWindow();
            }
        } else if (string.equals("&setWindowState") && stack.size() == 2) {
            String string4 = stack.pop().toString();
            String string5 = stack.pop().toString().toUpperCase();
            if (this.session.isWindow(string4)) {
                if (string5.equals("NORMAL")) {
                    this.session.getWindow(string4).getWindow().setMaximum(false);
                    this.session.getWindow(string4).getWindow().setIcon(false);
                } else if (string5.equals("MAXIMIZED")) {
                    this.session.getWindow(string4).getWindow().setIcon(false);
                    this.session.getWindow(string4).getWindow().setMaximum(true);
                } else if (string5.equals("MINIMIZED")) {
                    this.session.getWindow(string4).getWindow().setIcon(true);
                }
            }
        } else if (string.equals("&setWindowState") && stack.size() == 1) {
            String string6 = stack.pop().toString().toUpperCase();
            JFrame jFrame = SessionManager.getGlobalCapabilities().getFrame();
            if (string6.equals("NORMAL")) {
                jFrame.setExtendedState(0);
            } else if (string6.equals("MAXIMIZED")) {
                jFrame.setExtendedState(6);
            } else if (string6.equals("MINIMIZED")) {
                jFrame.setExtendedState(1);
            }
        } else {
            if (string.equals("&getWindowState") && stack.size() == 0) {
                JFrame jFrame = SessionManager.getGlobalCapabilities().getFrame();
                int n = jFrame.getExtendedState();
                if ((n & 1) == 1) {
                    return SleepUtils.getScalar("MINIMIZED");
                }
                if ((n & 6) == 6) {
                    return SleepUtils.getScalar("MAXIMIZED");
                }
                return SleepUtils.getScalar("NORMAL");
            }
            if (string.equals("&getWindowState") && stack.size() == 1) {
                String string7 = stack.pop().toString();
                if (this.session.isWindow(string7)) {
                    if (this.session.getWindow(string7).getWindow().isMaximum()) {
                        return SleepUtils.getScalar("MAXIMIZED");
                    }
                    if (this.session.getWindow(string7).getWindow().isIcon()) {
                        return SleepUtils.getScalar("MINIMIZED");
                    }
                    return SleepUtils.getScalar("NORMAL");
                }
            } else {
                if (string.equals("&getActiveWindow")) {
                    if (this.session.getRealActiveWindow() == null) {
                        return SleepUtils.getScalar("%STATUS%");
                    }
                    return SleepUtils.getScalar(this.session.getRealActiveWindow().getName());
                }
                if (string.equals("&getCurrentWindow")) {
                    return SleepUtils.getScalar(this.session.getActiveWindow().getName());
                }
                if (string.equals("&getWindows")) {
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                    Iterator iterator = this.session.getAllWindows().iterator();
                    while (iterator.hasNext()) {
                        StatusWindow statusWindow = (StatusWindow)iterator.next();
                        linkedHashSet.add(statusWindow.getName());
                    }
                    return SleepUtils.getArrayWrapper(linkedHashSet);
                }
                if (string.equals("&activateWindow") && stack.size() == 1) {
                    String string8 = stack.pop().toString();
                    if (this.session.isWindow(string8)) {
                        this.session.getWindow(string8).getWindow().activate();
                    }
                } else if (string.equals("&tileWindows")) {
                    if (this.session.getDesktop() instanceof ClientDesktop) {
                        ClientUtils.invokeLater(new Runnable(){

                            public void run() {
                                ((ClientDesktop)WindowManagementOperators.this.session.getDesktop()).tileWindows();
                            }
                        });
                    }
                } else if (string.equals("&cascadeWindows") && this.session.getDesktop() instanceof ClientDesktop) {
                    ClientUtils.invokeLater(new Runnable(){

                        public void run() {
                            ((ClientDesktop)WindowManagementOperators.this.session.getDesktop()).cascadeWindows();
                        }
                    });
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }
}

