/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.toolkit;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JToolBar;
import rero.config.ClientState;
import rero.config.ClientStateListener;

public class OrientedToolBar
extends JToolBar
implements ClientStateListener {
    public static final int BUTTON_FIXED_WIDTH = 95;
    private FlowLayout2 fixed = null;
    private GridLayout2 fill = null;

    public OrientedToolBar() {
        this.setFloatable(false);
        this.propertyChanged(null, null);
        ClientState.getClientState().addClientStateListener("switchbar.fixed", this);
    }

    public void propertyChanged(String string, String string2) {
        int n = ClientState.getClientState().getInteger("switchbar.position", 0);
        if (n == 2 || n == 3) {
            this.setLayout(new GridLayout3());
            this.validate();
        } else if (ClientState.getClientState().isOption("switchbar.fixed", false)) {
            if (this.fixed == null || this.fill == null) {
                this.fixed = new FlowLayout2(0, 0, 0);
                this.fill = new GridLayout2();
            }
            this.setLayout(this.fixed);
            this.validate();
        } else {
            this.setLayout(new GridLayout());
            this.validate();
        }
    }

    public void setOrientation(int n) {
        this.propertyChanged(null, null);
    }

    private class GridLayout3
    extends GridLayout {
        private GridLayout3() {
        }

        public int getColumns() {
            return 1;
        }

        public void layoutContainer(Container container) {
            if (container.getComponentCount() > 0) {
                int n = OrientedToolBar.this.getComponent((int)0).getPreferredSize().height + this.getVgap();
                if (n * container.getComponentCount() > container.getHeight()) {
                    this.setRows(container.getComponentCount());
                    this.setColumns(1);
                } else {
                    this.setRows(container.getHeight() / n);
                    this.setColumns(1);
                }
            }
            super.layoutContainer(container);
        }
    }

    private class GridLayout2
    extends GridLayout {
        private GridLayout2() {
        }

        public void layoutContainer(Container container) {
            if (container.getComponentCount() * 97 < container.getWidth()) {
                container.setLayout(OrientedToolBar.this.fixed);
                container.validate();
            } else {
                super.layoutContainer(container);
            }
        }
    }

    private class FlowLayout2
    extends FlowLayout {
        public FlowLayout2(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        public void layoutContainer(Container container) {
            if (container.getComponentCount() * 97 < container.getWidth()) {
                super.layoutContainer(container);
            } else {
                container.setLayout(OrientedToolBar.this.fill);
                container.validate();
            }
        }
    }
}

