/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import contrib.javapro.JSortTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rero.gui.SessionManager;
import rero.gui.toolkit.GeneralListModel;
import rero.gui.windows.GeneralListDialog;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.ClientUtils;
import rero.util.StringUtils;
import rero.util.TokenizedString;
import text.AttributedString;

public class ChannelListDialog
extends GeneralListDialog
implements ActionListener {
    protected JTextField search;
    protected JLabel label;
    protected JSortTable table;

    public void actionPerformed(ActionEvent actionEvent) {
        ((ChannelTableModel)this.model).search(this.search.getText());
    }

    public void init() {
        this.capabilities.addTemporaryListener((ChannelTableModel)this.model);
    }

    public void processMouseEvent(MouseEvent mouseEvent, int n) {
        ChannelTableModel channelTableModel = (ChannelTableModel)this.model;
        SessionManager.getGlobalCapabilities().getActiveSession().executeCommand("/JOIN " + ((LChannel)channelTableModel.getData().get(n)).getChannel());
    }

    public ChannelListDialog() {
        super("Channel List", "list", new ChannelTableModel());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setOpaque(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.search = new JTextField();
        this.search.setColumns(12);
        this.search.addActionListener(this);
        JButton jButton = new JButton("Search");
        jButton.addActionListener(this);
        jPanel2.add(this.search);
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "East");
        this.label = new JLabel("Waiting for the storm...");
        ((ChannelTableModel)this.model).setLabel(this.label);
        jPanel.add((Component)this.label, "Center");
        this.add((Component)jPanel, "North");
    }

    public String getWindowType() {
        return "ListDialog";
    }

    private static class ChannelTableModel
    extends GeneralListModel
    implements ChatListener,
    FrameworkConstants {
        protected ArrayList filter = null;
        protected ArrayList channels = new ArrayList(10000);
        protected int x = 0;
        protected JLabel label;

        public HashMap getEventHashMap(int n) {
            LChannel lChannel = (LChannel)this.getData().get(n);
            return ClientUtils.getEventHashMap(lChannel.getChannel(), lChannel.getUsers() + " " + lChannel.getTopic());
        }

        public void setLabel(JLabel jLabel) {
            this.label = jLabel;
        }

        public boolean isChatEvent(String string, HashMap hashMap) {
            return string.equals("321") || string.equals("322") || string.equals("323");
        }

        public void search(String string) {
            if (string.equals("")) {
                this.filter = null;
                this.fireTableDataChanged();
                return;
            }
            this.filter = new ArrayList();
            Iterator iterator = this.channels.iterator();
            while (iterator.hasNext()) {
                LChannel lChannel = (LChannel)iterator.next();
                if (!lChannel.matches(string)) continue;
                this.filter.add(lChannel);
            }
            this.fireTableDataChanged();
        }

        private ArrayList getData() {
            if (this.filter != null) {
                return this.filter;
            }
            return this.channels;
        }

        public int fireChatEvent(HashMap hashMap) {
            String string = (String)hashMap.get("$event");
            if (string.equals("321")) {
                this.label.setText("... Listing Channels ...");
                this.channels.clear();
                this.filter = null;
                this.fireTableDataChanged();
            }
            if (string.equals("322")) {
                TokenizedString tokenizedString = new TokenizedString(hashMap.get("$parms").toString());
                tokenizedString.tokenize(" ");
                this.channels.add(new LChannel(tokenizedString.getToken(0), Integer.parseInt(tokenizedString.getToken(1)), tokenizedString.getTokenFrom(2)));
                if (this.x % 1000 == 0) {
                    this.fireTableDataChanged();
                }
                if (this.x > 10000 && this.x < 11000) {
                    this.label.setText("Go grab a beer, this is gonna be awhile...");
                } else if (this.x > 20000 && this.x < 21000) {
                    this.label.setText("I bet we're not even halfway there yet");
                } else if (this.x > 25000 && this.x < 26000) {
                    this.label.setText("So what do you do for a living?");
                } else if (this.x > 26000 && this.x < 26500) {
                    this.label.setText("Really, does that make you gay?");
                } else if (this.x > 26500 && this.x < 27500) {
                    this.label.setText("Don't worry, I don't judge");
                } else if (this.x > 27500 && this.x < 28500) {
                    this.label.setText("I'm just an irc client... or am I?");
                } else if (this.x > 35000 && this.x < 36000) {
                    this.label.setText("I love you.  You love me.  We're a happy...");
                } else if (this.x > 36000 && this.x < 36500) {
                    this.label.setText("... family?");
                } else if (this.x > 43000 && this.x < 44000) {
                    this.label.setText("How many freaking channels are on this network?");
                } else if (this.x % 175 == 0) {
                    this.label.setText(".x. Listing Channels .x.: " + this.channels.size());
                } else if (this.x % 175 == 43) {
                    this.label.setText("..x Listing Channels ..x: " + this.channels.size());
                } else if (this.x % 175 == 81) {
                    this.label.setText(".x. Listing Channels .x.: " + this.channels.size());
                } else if (this.x % 175 == 127) {
                    this.label.setText("x.. Listing Channels x..: " + this.channels.size());
                }
                ++this.x;
            }
            if (string.equals("323")) {
                this.label.setText("Channel /list complete: " + this.channels.size() + " channels");
                this.x = 0;
                this.fireTableDataChanged();
                return 5;
            }
            return 2;
        }

        public void sortColumn(int n, boolean bl) {
            Collections.sort(this.getData(), new ChannelComparator(n, bl));
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.getData().size();
        }

        public int getColumnCount() {
            return 3;
        }

        public int getColumnWidth(int n) {
            if (n == 0) {
                return 150;
            }
            if (n == 1) {
                return 75;
            }
            return -1;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "#Channel";
                }
                case 1: {
                    return "Users";
                }
                case 2: {
                    return "Current Topic";
                }
            }
            return "Unknown";
        }

        public Object getValueAt(int n, int n2) {
            if (n >= this.getData().size()) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return ((LChannel)this.getData().get(n)).getChannelAttributed();
                }
                case 1: {
                    return ((LChannel)this.getData().get(n)).getUsersAttributed();
                }
                case 2: {
                    return ((LChannel)this.getData().get(n)).getTopicAttributed();
                }
            }
            return "Unknown";
        }
    }

    private static class ChannelComparator
    implements Comparator {
        private int criteria;
        private boolean reverse;

        public ChannelComparator(int n, boolean bl) {
            this.criteria = n;
            this.reverse = bl;
        }

        public int compare(Object object, Object object2) {
            LChannel lChannel = (LChannel)object;
            LChannel lChannel2 = (LChannel)object2;
            if (this.reverse) {
                LChannel lChannel3 = lChannel2;
                lChannel2 = lChannel;
                lChannel = lChannel3;
            }
            switch (this.criteria) {
                case 0: {
                    return lChannel.getChannel().compareTo(lChannel2.getChannel());
                }
                case 1: {
                    if (lChannel.getUsers() < lChannel2.getUsers()) {
                        return 1;
                    }
                    if (lChannel.getUsers() > lChannel2.getUsers()) {
                        return -1;
                    }
                    return 0;
                }
                case 2: {
                    return lChannel.getTopic().compareTo(lChannel2.getTopic());
                }
            }
            return 0;
        }
    }

    private static class LChannel {
        private String name;
        private String topic;
        private int users;
        private AttributedString topicattrs;
        private AttributedString nameattrs;
        private AttributedString userattrs;

        public LChannel(String string, int n, String string2) {
            this.name = string;
            this.users = n;
            this.topic = string2;
            if (this.topic.equals(":")) {
                this.topic = "";
            }
        }

        public String getChannel() {
            return this.name;
        }

        public String getTopic() {
            return this.topic;
        }

        public AttributedString getTopicAttributed() {
            if (this.topicattrs != null) {
                return this.topicattrs;
            }
            this.topicattrs = AttributedString.CreateAttributedString(this.topic);
            this.topicattrs.assignWidths();
            return this.topicattrs;
        }

        public AttributedString getChannelAttributed() {
            if (this.nameattrs != null) {
                return this.nameattrs;
            }
            this.nameattrs = AttributedString.CreateAttributedString(this.name);
            this.nameattrs.assignWidths();
            return this.nameattrs;
        }

        public AttributedString getUsersAttributed() {
            if (this.userattrs != null) {
                return this.userattrs;
            }
            this.userattrs = AttributedString.CreateAttributedString(this.users + "");
            this.userattrs.assignWidths();
            return this.userattrs;
        }

        public int getUsers() {
            return this.users;
        }

        public boolean matches(String string) {
            if (string.indexOf(42) > -1 || string.indexOf(63) > -1) {
                return StringUtils.iswm(string.toUpperCase(), (this.getChannel() + " " + StringUtils.strip(this.getTopic())).toUpperCase());
            }
            return (this.getChannel() + " " + StringUtils.strip(this.getTopic())).toUpperCase().indexOf(string.toUpperCase()) > -1;
        }
    }
}

