/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import rero.bridges.menu.ScriptedPopupMenu;
import rero.client.Capabilities;
import rero.config.ClientState;
import rero.gui.windows.ChannelListData;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ListBoxOptions;
import rero.gui.windows.StatusWindow;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import rero.ircfw.User;
import rero.ircfw.interfaces.ChannelDataWatch;
import text.ListDisplay;
import text.event.ClickEvent;
import text.event.ClickListener;
import text.list.ListElement;

public class ChannelWindow
extends StatusWindow
implements ChannelDataWatch {
    protected Channel channel;
    protected ListDisplay listbox;
    protected ChannelListData data;
    protected Capabilities capabilities;
    protected MouseAdapter mouseListener;
    protected ListBoxOptions watcher;
    protected LinkedList listeners = new LinkedList();

    public ListDisplay getListbox() {
        return this.listbox;
    }

    public void cleanup() {
        ((InternalDataList)this.capabilities.getDataStructure("clientInformation")).installChannelWatch(this.channel.getName(), null);
        this.watcher = null;
        this.listeners.clear();
        super.cleanup();
    }

    public ChannelWindow(Channel channel) {
        this.channel = channel;
    }

    public void init(ClientWindow clientWindow) {
        super.init(clientWindow);
        this.data = new ChannelListData(this.channel);
        this.listbox = new ListDisplay(this.data);
        this.watcher = new ListBoxOptions(this, this.listbox);
        this.mouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ChannelWindow.this.maybeShowPopupNicklist(mouseEvent, "nicklist");
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ChannelWindow.this.maybeShowPopupNicklist(mouseEvent, "nicklist");
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2 && !mouseEvent.isPopupTrigger() && (mouseEvent.getButton() & 3) != 3) {
                    ChannelWindow.this.fireClickEvent(mouseEvent);
                } else {
                    ChannelWindow.this.maybeShowPopupNicklist(mouseEvent, "nicklist");
                }
            }
        };
        this.listbox.addMouseListener(this.mouseListener);
    }

    protected void maybeShowPopupNicklist(MouseEvent mouseEvent, String string) {
        JPopupMenu jPopupMenu = this.getPopupMenu(string, null);
        if (mouseEvent.isPopupTrigger() && jPopupMenu != null) {
            ListElement listElement = this.listbox.getSelectedElement();
            if (listElement != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                User user = (User)listElement.getSource();
                hashMap.put("$snick", user.getNick());
                Iterator iterator = this.listbox.getSelectedElements().iterator();
                StringBuffer stringBuffer = new StringBuffer();
                while (iterator.hasNext()) {
                    User user2 = (User)((ListElement)iterator.next()).getSource();
                    stringBuffer.append(user2.getNick());
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(" ");
                }
                hashMap.put("$data", this.getName() + " " + stringBuffer.toString());
                ScriptedPopupMenu.SetMenuData(hashMap);
            }
            jPopupMenu.show((JComponent)mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
    }

    public void createChannel(Channel channel) {
        this.channel = channel;
        this.data.installCapabilities(this.capabilities);
        this.data.updateChannel(this.channel);
    }

    public void userAdded(User user) {
        this.listbox.repaint();
    }

    public void userRemoved(User user) {
        this.data.removeUser(user);
        this.listbox.repaint();
    }

    public void userChanged() {
        this.listbox.repaint();
    }

    public void touch() {
        super.touch();
        this.listbox.repaint();
    }

    public void installCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
        super.installCapabilities(capabilities);
        this.data.installCapabilities(capabilities);
        ((InternalDataList)capabilities.getDataStructure("clientInformation")).installChannelWatch(this.channel.getName(), this);
    }

    public ImageIcon getImageIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(ClientState.getClientState().getResource("channel.gif"));
        }
        return this.icon;
    }

    public String getQuery() {
        return this.channel.getName();
    }

    public String getName() {
        return this.channel.getName();
    }

    public String getWindowType() {
        return "channel";
    }

    public void addClickListener(ClickListener clickListener) {
        this.listeners.add(clickListener);
    }

    public void fireClickEvent(MouseEvent mouseEvent) {
        String string = "";
        ListElement listElement = this.listbox.getSelectedElement();
        if (listElement != null) {
            User user = (User)listElement.getSource();
            string = user.getNick();
            ClickEvent clickEvent = new ClickEvent(string, string, mouseEvent);
            ListIterator listIterator = this.listeners.listIterator();
            while (listIterator.hasNext() && !clickEvent.isConsumed()) {
                ClickListener clickListener = (ClickListener)listIterator.next();
                clickListener.wordClicked(clickEvent);
            }
            if (!clickEvent.isConsumed()) {
                this.capabilities.getUserInterface().openQueryWindow(string, true);
            }
        }
    }

    public int compareWindowType() {
        return 2;
    }
}

