/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import rero.bridges.menu.MenuBridge;
import rero.client.Capabilities;
import rero.gui.input.InputField;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;
import rero.gui.windows.StatusWindow;
import rero.gui.windows.WindowStatusBar;
import text.WrappedDisplay;
import text.event.ClickEvent;
import text.event.ClickListener;

public abstract class EmptyWindow
extends StatusWindow
implements ClientWindowListener {
    private boolean isOpen = true;
    protected LinkedList listeners = new LinkedList();

    public void touch() {
    }

    public void installCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
        this.menuManager = (MenuBridge)capabilities.getDataStructure("menuBridge");
        this.init();
    }

    public InputField getInput() {
        return null;
    }

    public WrappedDisplay getDisplay() {
        return null;
    }

    public WindowStatusBar getStatusBar() {
        return null;
    }

    public void init(ClientWindow clientWindow) {
        this.frame = clientWindow;
        this.frame.addWindowListener(new StatusWindow.ClientWindowStuff(this));
        this.frame.addWindowListener(this);
        this.frame.setContentPane(this);
        this.setTitle(this.getName());
        this.frame.setIcon(this.getImageIcon());
    }

    public abstract void init();

    public String getQuery() {
        return "Nada";
    }

    public void setQuery(String string) {
    }

    public void setTitle(String string) {
        this.frame.setTitle(string);
    }

    public ClientWindow getWindow() {
        return this.frame;
    }

    public String getTitle() {
        return this.frame.getTitle();
    }

    public abstract String getName();

    public abstract ImageIcon getImageIcon();

    public String getWindowType() {
        return "Other";
    }

    public boolean isLegalWindow() {
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void onActive(ClientWindowEvent clientWindowEvent) {
    }

    public void onOpen(ClientWindowEvent clientWindowEvent) {
        this.isOpen = true;
    }

    public void onInactive(ClientWindowEvent clientWindowEvent) {
    }

    public void onMinimize(ClientWindowEvent clientWindowEvent) {
    }

    public void onClose(ClientWindowEvent clientWindowEvent) {
        this.isOpen = false;
    }

    public void addClickListener(ClickListener clickListener) {
        this.listeners.add(clickListener);
    }

    public void fireClickEvent(String string, MouseEvent mouseEvent) {
        ClickEvent clickEvent = new ClickEvent(string, this.getName(), mouseEvent);
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext() && !clickEvent.isConsumed()) {
            ClickListener clickListener = (ClickListener)listIterator.next();
            clickListener.wordClicked(clickEvent);
        }
    }

    public int compareWindowType() {
        return 4;
    }
}

