/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import contrib.javapro.JSortTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import rero.config.ClientState;
import rero.gui.toolkit.GeneralListModel;
import rero.gui.windows.EmptyWindow;
import text.AttributedLabel;
import text.AttributedString;
import text.TextSource;

public class GeneralListDialog
extends EmptyWindow {
    protected GeneralListModel model;
    protected JSortTable table;
    protected String popupHook;
    protected String name;

    public GeneralListDialog(String string, String string2, GeneralListModel generalListModel) {
        this.name = string;
        this.popupHook = string2;
        this.model = generalListModel;
        this.setLayout(new BorderLayout());
        this.table = new JSortTable(this.model);
        this.table.setOpaque(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setDefaultRenderer(new Object().getClass(), new MyRenderer());
        this.table.setShowGrid(false);
        this.table.setSelectionMode(0);
        this.table.setRowHeight(TextSource.fontMetrics.getHeight() + 2);
        JScrollPane jScrollPane = new JScrollPane(this.table, 22, 31);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
        int n = 0;
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        tableColumn.setMinWidth(1);
        tableColumn.setMaxWidth(this.model.getColumnWidth(n) * 3);
        tableColumn.setPreferredWidth(this.model.getColumnWidth(n));
        for (n = 1; n < this.model.getColumnCount() - 1; ++n) {
            tableColumn = this.table.getColumnModel().getColumn(n);
            tableColumn.setMinWidth(1);
            tableColumn.setMaxWidth(this.model.getColumnWidth(n) * 3);
            tableColumn.sizeWidthToFit();
        }
        this.table.setRowSelectionAllowed(true);
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        this.add(jScrollPane);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = GeneralListDialog.this.table.rowAtPoint(point);
                int n2 = GeneralListDialog.this.table.columnAtPoint(point);
                GeneralListDialog.this.maybeShowPopup(mouseEvent, GeneralListDialog.this.model.getEventHashMap(n));
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = GeneralListDialog.this.table.rowAtPoint(point);
                int n2 = GeneralListDialog.this.table.columnAtPoint(point);
                GeneralListDialog.this.maybeShowPopup(mouseEvent, GeneralListDialog.this.model.getEventHashMap(n));
                if (mouseEvent.getClickCount() == 2 && !mouseEvent.isPopupTrigger() && mouseEvent.getButton() == 1 && !mouseEvent.isConsumed()) {
                    GeneralListDialog.this.processMouseEvent(mouseEvent, n);
                    mouseEvent.consume();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = GeneralListDialog.this.table.rowAtPoint(point);
                int n2 = GeneralListDialog.this.table.columnAtPoint(point);
                GeneralListDialog.this.maybeShowPopup(mouseEvent, GeneralListDialog.this.model.getEventHashMap(n));
            }
        });
    }

    public void init() {
    }

    protected void maybeShowPopup(MouseEvent mouseEvent, HashMap hashMap) {
        JPopupMenu jPopupMenu = this.getPopupMenu(this.popupHook, hashMap);
        if (mouseEvent.isPopupTrigger() && jPopupMenu != null) {
            jPopupMenu.show((JComponent)mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
    }

    public String getName() {
        return this.name;
    }

    public ImageIcon getImageIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(ClientState.getClientState().getResource("status.gif"));
        }
        return this.icon;
    }

    public void processMouseEvent(MouseEvent mouseEvent, int n) {
        this.fireClickEvent(n + "", mouseEvent);
    }

    private static class MyRenderer
    implements TableCellRenderer {
        private JLabel select = new JLabel();
        private AttributedLabel labeln = new AttributedLabel();
        private AttributedLabel labels = new AttributedLabel();

        public MyRenderer() {
            this.select.setOpaque(true);
            this.select.setLayout(new BorderLayout());
            this.select.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.select.add(this.labels);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return new JLabel();
            }
            AttributedString attributedString = (AttributedString)object;
            if (bl) {
                this.select.setFont(TextSource.clientFont);
                this.select.setBackground(jTable.getSelectionBackground());
                this.select.setForeground(jTable.getSelectionForeground());
                this.select.setText(attributedString.getText());
                return this.select;
            }
            this.labeln.setText(attributedString);
            return this.labeln;
        }
    }
}

