/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import rero.bridges.menu.MenuBridge;
import rero.client.Capabilities;
import rero.config.ClientState;
import rero.gui.IRCAwareComponent;
import rero.gui.IRCSession;
import rero.gui.background.BackgroundPanel;
import rero.gui.input.InputField;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;
import rero.gui.windows.SwitchBarOptions;
import rero.gui.windows.WindowStatusBar;
import rero.util.ClientUtils;
import text.WrappedDisplay;

public class StatusWindow
extends BackgroundPanel
implements IRCAwareComponent,
Comparable {
    public static final String STATUS_NAME = "%STATUS%";
    protected WrappedDisplay display;
    protected InputField input;
    protected WindowStatusBar statusbar;
    protected JToggleButton button;
    protected ImageIcon icon;
    protected ClientWindow frame;
    protected String query = "";
    protected Capabilities capabilities;
    protected Color defaultForegroundColor;
    protected MenuBridge menuManager;

    public void cleanup() {
        if (this.display != null) {
            this.display.clear();
        }
        if (this.input != null) {
            this.input.cleanup();
        }
        this.removeAll();
    }

    public void touch() {
        this.statusbar.rehash();
        this.statusbar.repaint();
    }

    protected void maybeShowPopup(MouseEvent mouseEvent, String string) {
        JPopupMenu jPopupMenu;
        if (mouseEvent.isPopupTrigger() && (jPopupMenu = this.getPopupMenu(string, ClientUtils.getEventHashMap(this.getName(), this.getName()))) != null) {
            jPopupMenu.show((JComponent)mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
    }

    public void installCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
        this.statusbar.installCapabilities(capabilities);
        this.menuManager = (MenuBridge)capabilities.getDataStructure("menuBridge");
        this.input.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                StatusWindow.this.maybeShowPopup(mouseEvent, "input");
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                StatusWindow.this.maybeShowPopup(mouseEvent, "input");
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                StatusWindow.this.maybeShowPopup(mouseEvent, "input");
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                StatusWindow.this.maybeShowPopup(mouseEvent, StatusWindow.this.getWindowType());
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                StatusWindow.this.maybeShowPopup(mouseEvent, StatusWindow.this.getWindowType());
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                StatusWindow.this.maybeShowPopup(mouseEvent, StatusWindow.this.getWindowType());
            }
        };
        this.display.addMouseListener(mouseAdapter);
    }

    public JPopupMenu getPopupMenu(String string, HashMap hashMap) {
        return this.menuManager.getPopupMenu(string, hashMap);
    }

    public InputField getInput() {
        return this.input;
    }

    public WrappedDisplay getDisplay() {
        return this.display;
    }

    public WindowStatusBar getStatusBar() {
        return this.statusbar;
    }

    public void flag() {
        if (!this.getWindow().isSelected() && SwitchBarOptions.isHilightOn()) {
            this.getButton().setForeground(SwitchBarOptions.getHighlightColor());
        }
    }

    public void unflag() {
        if (SwitchBarOptions.isHilightOn()) {
            this.getButton().setForeground(this.defaultForegroundColor);
            this.getButton().repaint();
        }
    }

    public void init(ClientWindow clientWindow) {
        this.frame = clientWindow;
        this.frame.addWindowListener(new ClientWindowStuff());
        this.setLayout(new BorderLayout());
        this.display = new WrappedDisplay();
        this.input = new InputField();
        this.statusbar = new WindowStatusBar(this);
        this.add((Component)this.display, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.statusbar, "North");
        jPanel.add((Component)this.input, "South");
        jPanel.setOpaque(false);
        this.add((Component)jPanel, "South");
        this.frame.setContentPane(this);
        this.setTitle(this.getName());
        this.frame.setIcon(this.getImageIcon());
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
        this.statusbar.stateChanged(null);
    }

    public void setTitle(String string) {
        if (string != null && string.equals(STATUS_NAME)) {
            string = "Status";
        }
        this.frame.setTitle(string);
    }

    public ClientWindow getWindow() {
        return this.frame;
    }

    public String getTitle() {
        return this.frame.getTitle();
    }

    public void setName(String string) {
        this.getButton().setText(this.getName());
        this.getButton().repaint();
        this.setTitle(this.getName());
        this.touch();
    }

    public String getName() {
        return STATUS_NAME;
    }

    public ImageIcon getImageIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(ClientState.getClientState().getResource("status.gif"));
        }
        return this.icon;
    }

    public JToggleButton getButton() {
        if (this.button == null) {
            this.button = this.getName().equals(STATUS_NAME) ? new JToggleButton("Status", this.getImageIcon()) : new JToggleButton(this.getName(), this.getImageIcon());
            this.button.setHorizontalAlignment(2);
            this.button.setMargin(new Insets(0, 0, 0, 5));
            this.button.setFocusPainted(false);
            this.button.setPreferredSize(new Dimension(95, this.button.getPreferredSize().height));
            this.button.setSelected(false);
            this.defaultForegroundColor = this.button.getForeground();
            this.button.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = 1088;
                    if ((mouseEvent.getModifiersEx() & n) == n) {
                        String string = ((JToggleButton)mouseEvent.getSource()).getText();
                        IRCSession iRCSession = StatusWindow.this.capabilities.getGlobalCapabilities().getSessionManager().getActiveSession();
                        iRCSession.getWindow(string).getWindow().closeWindow();
                    } else {
                        StatusWindow.this.maybeShowPopup(mouseEvent, "switchbar");
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    StatusWindow.this.maybeShowPopup(mouseEvent, "switchbar");
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    StatusWindow.this.maybeShowPopup(mouseEvent, "switchbar");
                }
            });
        }
        return this.button;
    }

    public String getWindowType() {
        return "Status";
    }

    public int compareTo(Object object) {
        StatusWindow statusWindow = (StatusWindow)object;
        if (this.compareWindowType() == statusWindow.compareWindowType()) {
            return this.getName().toUpperCase().compareTo(((StatusWindow)object).getName().toUpperCase());
        }
        return this.compareWindowType() - statusWindow.compareWindowType();
    }

    public int compareWindowType() {
        return 1;
    }

    public boolean isLegalWindow() {
        return true;
    }

    protected class ClientWindowStuff
    implements ClientWindowListener {
        protected ClientWindowStuff() {
        }

        public void onActive(ClientWindowEvent clientWindowEvent) {
            StatusWindow.this.unflag();
        }

        public void onOpen(ClientWindowEvent clientWindowEvent) {
        }

        public void onInactive(ClientWindowEvent clientWindowEvent) {
        }

        public void onMinimize(ClientWindowEvent clientWindowEvent) {
        }

        public void onClose(ClientWindowEvent clientWindowEvent) {
            StatusWindow.this.cleanup();
        }
    }
}

