/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import rero.ircfw.Channel;
import rero.ircfw.MyUser;
import rero.ircfw.User;
import rero.ircfw.UserMode;
import rero.ircfw.interfaces.ChannelDataWatch;

public class InternalDataList {
    protected String myNickname = "<Unknown>";
    protected HashMap users = new HashMap();
    protected MyUser myInformation = new MyUser();
    protected HashMap channels = new HashMap();
    protected HashMap sync = new HashMap();
    protected HashMap wasOn = new HashMap();
    protected UserMode umode = new UserMode("ohv", "@%+");
    protected HashMap iSupport = new HashMap();
    protected HashMap chanModes = new HashMap();

    public void reset() {
        this.myNickname = "<Unknown>";
        this.users = new HashMap();
        this.myInformation = new MyUser();
        this.channels = new HashMap();
        this.umode = new UserMode("ohv", "@%+");
        this.iSupport = new HashMap();
        this.chanModes = new HashMap();
    }

    public boolean isChanGroupMode(String string, char c) {
        if (!this.chanModes.containsKey(string)) {
            return false;
        }
        String string2 = (String)this.chanModes.get(string);
        return string2.indexOf(c) > -1;
    }

    public void setChanGroupMode(String string, String string2) {
        this.chanModes.put(string, string2);
    }

    public Set getChannelsFromPriorLife(String string) {
        Set set = (Set)this.wasOn.get(string);
        this.wasOn.remove(set);
        return set;
    }

    public HashMap getSupportInfo() {
        return this.iSupport;
    }

    public void addSupportInfo(String string, String string2) {
        this.iSupport.put(string, string2);
    }

    public String getMyNick() {
        return this.myNickname;
    }

    public User getMyUser() {
        return this.getUser(this.getMyNick());
    }

    public UserMode getPrefixInfo() {
        return this.umode;
    }

    public void setPrefixInfo(String string, String string2) {
        this.umode = new UserMode(string, string2);
    }

    public void setMyNick(String string) {
        this.myNickname = string;
    }

    public MyUser getMyUserInformation() {
        return this.myInformation;
    }

    public void installChannelWatch(String string, ChannelDataWatch channelDataWatch) {
        this.sync.put(string.toUpperCase(), channelDataWatch);
    }

    public ChannelDataWatch getChannelDataWatch(Channel channel) {
        return (ChannelDataWatch)this.sync.get(channel.getName().toUpperCase());
    }

    public LinkedList nickCompleteAll(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.getChannel(string2) != null) {
            Set set = this.getChannel(string2).getAllUsers();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                if (user.getNick().length() < string.length()) continue;
                if (user.getNick().toLowerCase().substring(0, string.length()).equals(string.toLowerCase())) {
                    linkedList.addFirst(user.getNick());
                    continue;
                }
                if (user.getNick().toLowerCase().indexOf(string.toLowerCase()) <= -1 || user.getNick().toLowerCase().equals(this.getMyNick().toLowerCase())) continue;
                linkedList.addLast(user.getNick());
            }
        }
        linkedList.addLast(string);
        return linkedList;
    }

    public String nickComplete(String string, String string2) {
        if (this.getChannel(string2) == null) {
            return string;
        }
        Set set = this.getChannel(string2).getAllUsers();
        if (this.isUser(string) && set.contains(this.getUser(string))) {
            return string;
        }
        String string3 = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            if (user.getNick().length() < string.length()) continue;
            if (user.getNick().toLowerCase().substring(0, string.length()).equals(string.toLowerCase())) {
                return user.getNick();
            }
            if (user.getNick().toLowerCase().indexOf(string.toLowerCase()) <= -1 || user.getNick().toLowerCase().equals(this.getMyNick().toLowerCase())) continue;
            string3 = user.getNick();
        }
        if (string3 != null) {
            return string3;
        }
        return string;
    }

    public Collection getAllUsers() {
        return this.users.values();
    }

    public String toString() {
        return "[IDL for " + this.myNickname + " - users: " + this.users.size() + ", channels:  " + this.channels.size() + "]";
    }

    public boolean isUser(String string) {
        return this.users.get(string) != null;
    }

    public User getUser(String string) {
        if (this.users.get(string) == null) {
            this.users.put(string, new User(string));
        }
        return (User)this.users.get(string);
    }

    public Set getUsersWithMode(String string, char c) {
        return this.umode.getUsersWithMode(this.getChannel(string), c);
    }

    public void QuitNick(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = new LinkedList(this.getUser(string).getChannels()).iterator();
        while (iterator.hasNext()) {
            Channel channel = (Channel)iterator.next();
            this.RemoveUser(this.getUser(string), channel);
            hashSet.add(channel.getName());
        }
        this.wasOn.put(string, hashSet);
        this.users.remove(string);
    }

    public void PartNick(String string, Channel channel) {
        if (this.getMyNick().equals(string)) {
            Iterator iterator = channel.getAllUsers().iterator();
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                user.getChannelData().remove(channel);
                if (user.getChannelData().size() != 0) continue;
                this.users.remove(user);
            }
            channel.getAllUsers().clear();
            this.channels.remove(channel.getName().toUpperCase());
        }
        this.RemoveUser(this.getUser(string), channel);
    }

    public void JoinNick(String string, String string2) {
        if (this.getMyNick().equals(string)) {
            this.createChannel(string2);
        }
        this.getUser(string).getChannelData().put(this.getChannel(string2), new Integer(0));
        this.getChannel(string2).getAllUsers().add(this.getUser(string));
        if (this.getChannelDataWatch(this.getChannel(string2)) != null) {
            this.getChannelDataWatch(this.getChannel(string2)).userAdded(this.getUser(string));
        }
    }

    public void ChangeNick(String string, String string2) {
        Channel channel;
        User user = this.getUser(string);
        Iterator iterator = user.getChannels().iterator();
        while (iterator.hasNext()) {
            channel = (Channel)iterator.next();
            channel.getAllUsers().remove(user);
        }
        this.users.remove(string);
        user.setNick(string2);
        this.users.put(string2, user);
        iterator = user.getChannels().iterator();
        while (iterator.hasNext()) {
            channel = (Channel)iterator.next();
            channel.getAllUsers().add(user);
            if (this.getChannelDataWatch(channel) == null) continue;
            this.getChannelDataWatch(channel).userChanged();
        }
        if (string.equals(this.getMyNick())) {
            this.setMyNick(string2);
        }
    }

    public boolean isOn(User user, Channel channel) {
        return user != null && user.getChannels().contains(channel);
    }

    public void AddUser(String string, Channel channel) {
        int n = 0;
        while (this.umode.isPrefixChar(string.charAt(0))) {
            n = this.umode.setMode(n, this.umode.getModeForDisplay(string.charAt(0)));
            string = string.substring(1, string.length());
        }
        User user = this.getUser(string);
        if (user.getChannelData().containsKey(channel)) {
            if ((Integer)user.getChannelData().get(channel) != n) {
                user.getChannelData().put(channel, new Integer(n));
            }
        } else {
            user.getChannelData().put(channel, new Integer(n));
            channel.getAllUsers().add(user);
        }
    }

    public Channel getChannel(String string) {
        return (Channel)this.channels.get(string.toUpperCase());
    }

    public void createChannel(String string) {
        this.channels.put(string.toUpperCase(), new Channel(string));
        if (this.getChannelDataWatch(this.getChannel(string)) != null) {
            this.getChannelDataWatch(this.getChannel(string)).createChannel(this.getChannel(string));
        }
    }

    public void synchronizeUserPreChange(User user, Channel channel) {
        channel.getAllUsers().remove(user);
    }

    public void synchronizeUserPostChange(User user, Channel channel) {
        channel.getAllUsers().add(user);
        if (this.getChannelDataWatch(channel) != null) {
            this.getChannelDataWatch(channel).userChanged();
        }
    }

    public void RemoveUser(User user, Channel channel) {
        channel.getAllUsers().remove(user);
        user.getChannelData().remove(channel);
        if (user.getChannelData().size() == 0) {
            this.users.remove(user);
        }
        if (this.getChannelDataWatch(channel) != null) {
            this.getChannelDataWatch(channel).userRemoved(user);
        }
    }
}

