/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw;

import java.util.HashMap;
import java.util.regex.Pattern;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.StringParser;

public class Parsed1459
implements FrameworkConstants {
    protected static String nickPattern = "(.+?)";
    protected static String userPattern = "(.+?)";
    protected static String hostPattern2 = "(.+?)";
    protected static String hostPattern = "([\\w\\-\\=]++[[\\.|\\:][\\w\\-\\=]++]*)";
    protected static String channelPattern = "([\\#|\\&]\\S++)";
    protected static Pattern isHost = Pattern.compile(hostPattern);
    protected static Pattern isNickUserHost = Pattern.compile(nickPattern + "!(" + userPattern + "@" + hostPattern2 + ")");
    protected static Pattern isNick = Pattern.compile(nickPattern);
    protected static Pattern isNumeric = Pattern.compile("\\d++");
    protected static Pattern isColonPresent = Pattern.compile(":(.++)");
    protected static Pattern isWhiteSpace = Pattern.compile("XXX");
    protected HashMap eventInformation;

    public HashMap parseString(String string) {
        this.eventInformation = new HashMap();
        this.eventInformation.put("$raw", string);
        this.phase1(string, this.eventInformation);
        return this.eventInformation;
    }

    private HashMap phase1(String string, HashMap hashMap) {
        String[] stringArray;
        StringParser stringParser = new StringParser(string, isColonPresent);
        if (stringParser.matches()) {
            stringArray = stringParser.getParsedString(0).split("\\s", 2);
            this.parseSourceInformation(stringArray[0], hashMap);
            string = stringArray[1];
        }
        if (isNumeric.matcher((stringArray = string.split("\\s", 2))[0]).matches()) {
            hashMap.put("$numeric", stringArray[0]);
        }
        hashMap.put("$event", stringArray[0]);
        string = stringArray.length > 1 ? stringArray[1] : "";
        this.parseParameterInformation(string, hashMap);
        return hashMap;
    }

    private HashMap parseParameterInformation(String string, HashMap hashMap) {
        StringParser stringParser = new StringParser(string, isColonPresent);
        String[] stringArray = string.split("\\s", 2);
        int n = 0;
        if (!stringParser.matches()) {
            stringArray = string.split("\\s", 2);
            hashMap.put("$target", stringArray[0]);
            n = stringArray[0].length() + 1;
        } else {
            if ((string.charAt(1) == '#' || string.charAt(1) == '&') && string.indexOf(32) == -1) {
                string = string.substring(1, string.length());
                return this.parseParameterInformation(string, hashMap);
            }
            string = "<null> " + string;
            n = "<null>".length() + 1;
            stringArray = string.split("\\s", 2);
            stringParser = new StringParser(string, isColonPresent);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (!stringParser.matches() && stringArray.length > 1) {
            stringArray = string.split("\\s", 2);
            if (stringArray.length <= 1) continue;
            string = stringArray[1];
            stringBuffer.append(stringArray[0]);
            stringBuffer.append(" ");
            stringParser = new StringParser(string, isColonPresent);
        }
        if (stringParser.matches()) {
            stringBuffer.append(stringParser.getParsedString(0));
        } else if (!string.equals(":")) {
            stringBuffer.append(string);
        }
        hashMap.put("$data", stringBuffer.toString());
        if (n < stringBuffer.toString().length()) {
            hashMap.put("$parms", stringBuffer.toString().substring(n, stringBuffer.toString().length()));
        } else {
            hashMap.put("$parms", "");
        }
        return hashMap;
    }

    private HashMap parseSourceInformation(String string, HashMap hashMap) {
        StringParser stringParser = new StringParser(string, isNickUserHost);
        if (stringParser.matches()) {
            String[] stringArray = stringParser.getParsedStrings();
            hashMap.put("$nick", stringArray[0]);
            hashMap.put("$address", stringArray[1]);
            hashMap.put("$user", stringArray[2]);
            hashMap.put("$host", stringArray[3]);
            hashMap.put("$source", stringArray[0]);
            return hashMap;
        }
        stringParser = new StringParser(string, isHost);
        if (stringParser.matches()) {
            String[] stringArray = stringParser.getParsedStrings();
            hashMap.put("$server", stringArray[0]);
            hashMap.put("$nick", stringArray[0]);
            hashMap.put("$source", stringArray[0]);
            return hashMap;
        }
        stringParser = new StringParser(string, isNick);
        if (stringParser.matches()) {
            String[] stringArray = stringParser.getParsedStrings();
            hashMap.put("$nick", stringArray[0]);
            hashMap.put("$source", stringArray[0]);
        }
        return hashMap;
    }
}

