/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw;

import java.util.HashMap;
import java.util.Set;
import rero.ircfw.Channel;
import rero.ircfw.interfaces.FrameworkConstants;

public class User
implements Comparable,
FrameworkConstants {
    protected String nickname = "";
    protected HashMap channels = new HashMap();
    protected String address = "";
    protected long idle = System.currentTimeMillis();

    public void setNick(String string) {
        this.nickname = string;
    }

    public String getNick() {
        return this.nickname;
    }

    public User copy() {
        User user = new User(this.nickname);
        user.channels = new HashMap(this.channels);
        user.address = this.address;
        user.idle = this.idle;
        return user;
    }

    public int compareTo(Object object) {
        User user = (User)object;
        if (user == null) {
            return -1;
        }
        return this.getNick().toUpperCase().compareTo(user.getNick().toUpperCase());
    }

    public User(String string) {
        this.nickname = string;
    }

    public HashMap getChannelData() {
        return this.channels;
    }

    public Set getChannels() {
        return this.channels.keySet();
    }

    public int getModeFor(Channel channel) {
        return (Integer)this.channels.get(channel);
    }

    public void setModeFor(Channel channel, int n) {
        this.channels.put(channel, new Integer(n));
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public String getAddress() {
        return this.address;
    }

    public String getFullAddress() {
        return this.getNick() + "!" + this.getAddress();
    }

    public void touch() {
        this.idle = System.currentTimeMillis();
    }

    public int getIdleTime() {
        return (int)((System.currentTimeMillis() - this.idle) / 1000L);
    }

    public boolean isIdle() {
        return System.currentTimeMillis() - this.idle > 300000L;
    }

    public String toString() {
        return this.getNick();
    }
}

