/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import rero.ircfw.Channel;
import rero.ircfw.User;

public class UserMode {
    private String modes;
    private String chars;

    public UserMode(String string, String string2) {
        this.modes = string;
        this.chars = string2;
    }

    public Set getUsersWithMode(Channel channel, char c) {
        LinkedHashSet<User> linkedHashSet = new LinkedHashSet<User>();
        Iterator iterator = channel.getAllUsers().iterator();
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            int n = user.getModeFor(channel);
            if (!this.isMode(n, c)) continue;
            linkedHashSet.add(user);
        }
        return linkedHashSet;
    }

    public boolean isPrefixMode(char c) {
        return this.modes.indexOf(c) > -1;
    }

    public boolean isPrefixChar(char c) {
        return this.chars.indexOf(c) > -1;
    }

    public char getDisplayForMode(char c) {
        return this.chars.charAt(this.modes.indexOf(c));
    }

    public char getModeForDisplay(char c) {
        return this.modes.charAt(this.chars.indexOf(c));
    }

    public int getValueFor(char c) {
        return 1 << this.modes.length() - this.modes.indexOf(c);
    }

    public int setMode(int n, char c) {
        int n2 = this.getValueFor(c);
        return n | n2;
    }

    public int unsetMode(int n, char c) {
        int n2 = this.getValueFor(c);
        return n & ~n2;
    }

    public boolean isMode(int n, char c) {
        if (c == ' ' && n == 0) {
            return true;
        }
        int n2 = this.getValueFor(c);
        return (n & n2) == n2;
    }

    public String getModes() {
        return this.modes;
    }

    public String getChars() {
        return this.chars;
    }

    public String toString(int n) {
        for (int i = 0; i < this.modes.length(); ++i) {
            if (!this.isMode(n, this.modes.charAt(i))) continue;
            return String.valueOf(this.chars.charAt(i));
        }
        return "";
    }

    public String toString() {
        return "[UCM:(" + this.modes + ")" + this.chars + "]";
    }
}

