/*
 * Decompiled with CFR 0.152.
 */
package rero.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.ListIterator;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.net.SecureSocket;
import rero.net.SocketEvent;
import rero.net.SocketInformation;
import rero.net.interfaces.SocketDataListener;
import rero.net.interfaces.SocketStatusListener;
import rero.util.ClientUtils;

public class SocketConnection
implements Runnable,
ClientStateListener {
    protected Socket aSocket;
    protected Thread readThread;
    protected PrintStream aSocketOutput;
    protected BufferedReader aSocketInput;
    protected long delay;
    protected SocketInformation connectionInformation;
    private static boolean stripcodes;
    private static ClientStateListener listener2;
    LinkedList connectDisconnectListeners = new LinkedList();
    LinkedList messageReadListeners = new LinkedList();
    SocketEvent event = new SocketEvent();

    public void propertyChanged(String string, String string2) {
        try {
            if (this.aSocketInput != null && this.aSocket.isConnected()) {
                this.aSocketInput = new BufferedReader(ClientState.getProperInputStream(this.aSocket.getInputStream()));
                this.aSocketOutput = ClientState.getProperPrintStream(this.aSocket.getOutputStream());
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to switch encodings...");
            exception.printStackTrace();
        }
    }

    public void println(String string) {
        try {
            this.aSocketOutput.println(string);
            this.aSocketOutput.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void disconnect() {
        if (this.aSocket != null && this.aSocket.isConnected()) {
            try {
                if (!this.aSocket.isOutputShutdown()) {
                    this.aSocket.shutdownOutput();
                }
                if (!this.aSocket.isInputShutdown()) {
                    this.aSocket.shutdownInput();
                }
                this.aSocket.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.aSocket = null;
        }
    }

    public void connect(String string, int n) {
        this.connect(string, n, 0L, null, false);
    }

    public void connect(String string, int n, long l, String string2, boolean bl) {
        this.delay = l;
        if (this.readThread != null) {
            try {
                this.disconnect();
                this.readThread.interrupt();
                this.readThread.join(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.getSocketInformation().hostname = string;
        this.getSocketInformation().port = n;
        this.getSocketInformation().isSecure = bl;
        this.getSocketInformation().password = string2;
        this.getSocketInformation().network = "Unknown";
        this.readThread = new Thread(this);
        this.readThread.setName("Socket Read Thread for: " + string);
        this.readThread.start();
    }

    public void run() {
        this.aSocketInput = null;
        this.aSocketOutput = null;
        try {
            if (this.delay > 0L) {
                Thread.sleep(this.delay);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            this.aSocket = this.getSocketInformation().isSecure ? new SecureSocket(this.getSocketInformation().hostname, this.getSocketInformation().port).getSocket() : new Socket(this.getSocketInformation().hostname, this.getSocketInformation().port);
            this.aSocket.setSoLinger(true, 5);
            this.aSocket.setTcpNoDelay(true);
            this.aSocket.setSoTimeout(300000);
            this.aSocketOutput = ClientState.getProperPrintStream(this.aSocket.getOutputStream());
            this.aSocketInput = new BufferedReader(ClientState.getProperInputStream(this.aSocket.getInputStream()));
        }
        catch (UnknownHostException unknownHostException) {
            this.fireStatusEvent("unable to resolve hostname", false);
            return;
        }
        catch (Exception exception) {
            if (Thread.currentThread() != this.readThread) {
                return;
            }
            this.fireStatusEvent(exception.getMessage(), false);
            return;
        }
        if (this.aSocket != null) {
            this.fireStatusEvent("success", true);
        }
        String string = null;
        do {
            try {
                string = this.aSocketInput.readLine();
                if (string == null) continue;
                this.fireReadEvent(string);
            }
            catch (SocketException socketException) {
                this.fireStatusEvent(socketException.getMessage(), false);
                this.shutdownSocket();
                return;
            }
            catch (IOException iOException) {
                this.fireStatusEvent(iOException.getMessage(), false);
                this.shutdownSocket();
                return;
            }
            catch (Exception exception) {
                if (this.aSocket == null || !this.aSocket.isConnected()) {
                    this.fireStatusEvent(exception.getMessage(), false);
                    this.shutdownSocket();
                    return;
                }
                exception.printStackTrace();
            }
        } while (this.aSocket != null && this.aSocket.isConnected() && string != null);
        this.fireStatusEvent("disconnected.", false);
        this.shutdownSocket();
    }

    private void shutdownSocket() {
        try {
            if (this.aSocketInput != null) {
                this.aSocketInput.close();
            }
            if (this.aSocketOutput != null) {
                this.aSocketOutput.close();
            }
            if (this.aSocket != null) {
                this.aSocket.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SocketInformation getSocketInformation() {
        return this.connectionInformation;
    }

    public SocketConnection() {
        this.connectionInformation = new SocketInformation();
        this.event.socket = this;
        this.event.data = this.connectionInformation;
        ClientState.getClientState().addClientStateListener("client.encoding", this);
        if (listener2 == null) {
            listener2 = new StripCodesListener();
            listener2.propertyChanged(null, null);
            ClientState.getClientState().addClientStateListener("client.stripcodes", listener2);
        }
    }

    public void removeSocketStatusListener(SocketStatusListener socketStatusListener) {
        this.connectDisconnectListeners.remove(socketStatusListener);
    }

    public void removeSocketDataListener(SocketDataListener socketDataListener) {
        this.messageReadListeners.remove(socketDataListener);
    }

    public void addSocketStatusListener(SocketStatusListener socketStatusListener) {
        this.connectDisconnectListeners.addFirst(socketStatusListener);
    }

    public void addSocketDataListener(SocketDataListener socketDataListener) {
        this.messageReadListeners.addFirst(socketDataListener);
    }

    public void fireStatusEvent(String string, boolean bl) {
        this.getSocketInformation().isConnected = bl;
        this.event.message = string;
        this.event.valid = true;
        ListIterator listIterator = this.connectDisconnectListeners.listIterator();
        while (listIterator.hasNext() && this.event.valid) {
            SocketStatusListener socketStatusListener = (SocketStatusListener)listIterator.next();
            socketStatusListener.socketStatusChanged(this.event);
        }
    }

    public void fireReadEvent(String string) {
        if (stripcodes) {
            string = ClientUtils.strip(string);
        }
        this.event.message = string;
        this.event.valid = true;
        ListIterator listIterator = this.messageReadListeners.listIterator();
        while (listIterator.hasNext() && this.event.valid) {
            SocketDataListener socketDataListener = (SocketDataListener)listIterator.next();
            socketDataListener.socketDataRead(this.event);
        }
    }

    static {
        listener2 = null;
    }

    private static class StripCodesListener
    implements ClientStateListener {
        private StripCodesListener() {
        }

        public void propertyChanged(String string, String string2) {
            stripcodes = ClientState.getClientState().isOption("client.stripcodes", false);
        }
    }
}

