/*
 * Decompiled with CFR 0.152.
 */
package rero.test;

import java.net.URI;

public class QuickConnect {
    private static QuickConnect qc = null;
    private URI info;

    public static boolean IsQuickConnect() {
        return qc != null;
    }

    public QuickConnect(URI uRI) {
        qc = this;
        this.info = uRI;
    }

    public String getConnectCommand() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/server ");
        if (this.isSSL()) {
            stringBuffer.append("-ssl ");
        }
        stringBuffer.append(this.getServer());
        stringBuffer.append(" ");
        stringBuffer.append(this.getPort());
        return stringBuffer.toString();
    }

    public static QuickConnect GetInformation() {
        return qc;
    }

    public URI getURL() {
        return this.info;
    }

    public String getNickname() {
        if (this.info.getUserInfo() != null) {
            return this.info.getUserInfo();
        }
        return "Guest_" + System.currentTimeMillis() % 100L;
    }

    public boolean isSSL() {
        System.out.println(this.info.getScheme());
        return "ircs".equals(this.info.getScheme());
    }

    public String getPort() {
        if (this.info.getPort() > -1) {
            return this.info.getPort() + "";
        }
        return "6667";
    }

    public String getServer() {
        String string = this.info.getHost();
        if (this.info.getPath() == null || this.info.getPath().length() == 0) {
            qc = null;
            this.info = null;
        }
        return string;
    }

    public String getCommand() {
        String string = "/join #" + this.info.getPath().substring(1, this.info.getPath().length()) + " " + this.info.getQuery();
        qc = null;
        this.info = null;
        return string;
    }
}

