/*
 * Decompiled with CFR 0.152.
 */
package rero.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import rero.config.ClientState;
import rero.gui.GlobalCapabilities;
import rero.gui.SessionManager;
import rero.ident.IdentDaemon;
import rero.test.ProxySettings;
import rero.test.QuickConnect;

public class WindowTest {
    protected JFrame frame;

    private static void checkEnvironment() {
        String string;
        boolean bl = false;
        try {
            string = System.getProperty("java.specification.version");
            double d = Double.parseDouble(string);
            bl = d == 1.4 ? System.getProperty("java.vm.version").indexOf("1.4.1") > -1 || System.getProperty("java.vm.version").indexOf("1.4.0") > -1 : d < 1.4;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            string = "Outdated Java Error:\njIRC Requires a java virtual machine compatible \nwith Java 1.4.2 or greater.  Download the latest \nversion of " + System.getProperty("java.vendor") + "'s Java at\n" + System.getProperty("java.vendor.url") + "\nYou are running: Java " + System.getProperty("java.version");
            System.err.println(string);
            Frame frame = new Frame();
            JOptionPane.showMessageDialog(frame, string, "Outdated Java Error", 0);
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) {
        WindowTest.checkEnvironment();
        int n = 0;
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.macos.smallTabs", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "jIRCii");
            try {
                Class<?> clazz = Class.forName("apple.OSXAdapter");
                Class[] classArray = new Class[]{};
                Method method = clazz.getDeclaredMethod("registerMacOSXApplication", classArray);
                if (method != null) {
                    method.invoke(clazz, new Object[0]);
                }
            }
            catch (Exception exception) {
                System.err.println("Exception while loading the OSXAdapter:");
                exception.printStackTrace();
            }
        }
        if (n + 1 < stringArray.length && stringArray[n].equals("-settings")) {
            ClientState.setBaseDirectory(stringArray[n + 1]);
            n += 2;
        }
        try {
            if (n + 1 < stringArray.length && stringArray[n].equals("-lnf")) {
                UIManager.setLookAndFeel(stringArray[n + 1]);
                n += 2;
            } else if (ClientState.getClientState().isOption("ui.native", true) && !"com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(UIManager.getSystemLookAndFeelClassName())) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            System.err.println("Could not load specified look and feel, using system default");
            exception.printStackTrace();
        }
        ProxySettings.initialize();
        IdentDaemon.initialize();
        if (n < stringArray.length && (stringArray[n].indexOf("irc://") > -1 || stringArray[n].indexOf("ircs://") > -1)) {
            try {
                new QuickConnect(new URI(stringArray[n]));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        new WindowTest();
    }

    public WindowTest() {
        GlobalCapabilities.frame = this.frame = new JFrame("jIRCii");
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)new SessionManager(this.frame), "Center");
        this.frame.setIconImage(ClientState.getClientState().getIcon("jirc.icon", "jicon.jpg").getImage());
        int n = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2;
        this.frame.setBounds(ClientState.getClientState().getBounds("desktop.bounds", Toolkit.getDefaultToolkit().getScreenSize(), new Dimension(640, 480)));
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SessionManager.getGlobalCapabilities().QuitClient();
            }
        });
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                if (ClientState.getClientState().isOption("desktop.relative", false) || ClientState.getClientState().isOption("window.relative", false) || ClientState.getClientState().isOption("statusbar.relative", false)) {
                    WindowTest.this.frame.validate();
                    ClientState.getClientState().fireChange("desktop");
                    ClientState.getClientState().fireChange("window");
                    ClientState.getClientState().fireChange("statusbar");
                    WindowTest.this.frame.repaint();
                }
            }
        });
        this.frame.show();
    }
}

