/*
 * Decompiled with CFR 0.152.
 */
package rero.util;

import javax.swing.SwingUtilities;
import rero.util.TimerListener;

public class TimedEvent {
    protected TimerListener listener;
    protected Runnable executeMe;
    protected long lastTouched;
    protected int repeats;
    protected long waitTime;

    public TimedEvent(TimerListener timerListener) {
        this(timerListener, 60000L, -1);
    }

    public TimedEvent(TimerListener timerListener, long l) {
        this(timerListener, l, -1);
    }

    public TimedEvent(TimerListener timerListener, long l, int n) {
        this.listener = timerListener;
        this.lastTouched = System.currentTimeMillis();
        this.repeats = n;
        this.waitTime = l;
        this.executeMe = new Runnable(){

            public void run() {
                TimedEvent.this.listener.timerExecute();
            }
        };
    }

    public TimerListener getListener() {
        return this.listener;
    }

    public void finish() {
        this.repeats = 0;
    }

    public boolean isValid() {
        return this.repeats != 0;
    }

    public boolean isReady() {
        return System.currentTimeMillis() - this.lastTouched >= this.waitTime;
    }

    public void timerExecute() {
        SwingUtilities.invokeLater(this.executeMe);
        this.lastTouched = System.currentTimeMillis();
        if (this.repeats > 0) {
            --this.repeats;
        }
    }
}

