/*
 * Decompiled with CFR 0.152.
 */
package rero.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import rero.util.TimedEvent;
import rero.util.TimerListener;

public class TimerUtil
implements Runnable {
    protected long resolution = 15000L;
    protected List timers = new LinkedList();

    public void setResolution(long l) {
        this.resolution = l == 0L && this.resolution > 1000L ? 1000L : l;
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.setName("jIRCii TIMER Thread");
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    TimedEvent timedEvent;
                    LinkedList<TimedEvent> linkedList = new LinkedList<TimedEvent>();
                    Iterator iterator = this.timers.iterator();
                    while (iterator.hasNext()) {
                        timedEvent = (TimedEvent)iterator.next();
                        if (timedEvent.isValid()) {
                            if (!timedEvent.isReady()) continue;
                            linkedList.add(timedEvent);
                            continue;
                        }
                        iterator.remove();
                    }
                    iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        timedEvent = (TimedEvent)iterator.next();
                        timedEvent.timerExecute();
                    }
                    Thread.sleep(this.resolution);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void addTimer(TimerListener timerListener, long l, int n) {
        if (l < this.resolution) {
            this.setResolution(l);
        }
        this.addTimer(new TimedEvent(timerListener, l, n));
    }

    public void addTimer(TimerListener timerListener, long l) {
        if (l < this.resolution) {
            this.setResolution(l);
        }
        this.addTimer(new TimedEvent(timerListener, l));
    }

    public void stopTimer(TimerListener timerListener) {
        HashSet hashSet = new HashSet();
        ListIterator listIterator = this.timers.listIterator();
        while (listIterator.hasNext()) {
            TimedEvent timedEvent = (TimedEvent)listIterator.next();
            if (timedEvent.getListener() != timerListener) continue;
            timedEvent.finish();
        }
    }

    public void addTimer(TimedEvent timedEvent) {
        this.timers.add(timedEvent);
    }
}

