/*
 * Decompiled with CFR 0.152.
 */
package rero.util;

import rero.util.hidden.MyTokenizer;

public class TokenizedString {
    protected String text;
    protected String tokenDelimeter;
    protected String[] stringToken;
    protected String[] tokenUpCache;
    protected String[] tokenDownCache;
    protected int totalTokens;

    public String getString() {
        return this.text;
    }

    public TokenizedString(String string) {
        this.text = string;
    }

    public TokenizedString(String string, String string2) {
        this.text = string;
        this.tokenize(string2);
    }

    public int tokenize(String string) {
        MyTokenizer myTokenizer = new MyTokenizer(this.text, string);
        this.stringToken = new String[myTokenizer.countTokens()];
        this.tokenUpCache = new String[myTokenizer.countTokens()];
        this.tokenDownCache = new String[myTokenizer.countTokens()];
        this.totalTokens = this.stringToken.length;
        this.tokenDelimeter = string;
        for (int i = 0; i < this.totalTokens; ++i) {
            this.stringToken[i] = myTokenizer.nextToken();
        }
        return this.totalTokens;
    }

    public String getTokenRange(int n, int n2) {
        if (n == 0) {
            return this.getTokenTo(n2);
        }
        if (n == n2) {
            return "";
        }
        if (n > n2) {
            return "";
        }
        String string = this.getTokenTo(n);
        String string2 = this.getTokenTo(n2 + 1);
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = this.tokenDelimeter.length();
        int n6 = this.text.length();
        while (n3 + n5 < n6 && this.text.substring(n3, n3 + n5).equals(this.tokenDelimeter)) {
            n3 += n5;
        }
        return this.text.substring(n3, n4);
    }

    public String getTokenTo(int n) {
        if (n >= this.tokenDownCache.length) {
            return this.text;
        }
        if (this.tokenDownCache[n] == null) {
            this.tokenDownCache[n] = TokenizedString.gettokdn(this.text, n, this.tokenDelimeter);
        }
        return this.tokenDownCache[n];
    }

    public String getTokenFrom(int n) {
        if (n >= this.tokenDownCache.length) {
            return "";
        }
        if (this.tokenUpCache[n] == null) {
            this.tokenUpCache[n] = TokenizedString.gettokup(this.text, n, this.tokenDelimeter);
        }
        return this.tokenUpCache[n];
    }

    public boolean isTokenized(String string, String string2) {
        return string.equals(this.text) && string2.equals(this.tokenDelimeter);
    }

    public int getTotalTokens() {
        return this.totalTokens;
    }

    public String getToken(int n) {
        if (n < this.totalTokens) {
            return this.stringToken[n];
        }
        return null;
    }

    public String toString() {
        String string = "---     jString:Report      ---\n";
        string = string + "Original String: " + this.text + "\n";
        string = string + "Token Delimeter: \"" + this.tokenDelimeter + "\"\n";
        string = string + "Total Tokens   : " + this.totalTokens + "\n";
        string = string + "---       Token:Breakdown   ---\n";
        for (int i = 0; i < this.totalTokens; ++i) {
            string = string + i + ")  " + this.getToken(i) + "\n";
        }
        string = string + "---         END:REPORT      ---\n";
        return string;
    }

    protected static String gettokup(String string, int n, String string2) {
        if (n == 0) {
            return string;
        }
        String string3 = TokenizedString.gettokdn(string, n, string2);
        int n2 = string3.length();
        int n3 = string2.length();
        int n4 = string.length();
        if (n2 < n4) {
            while (n2 + n3 < n4 && string.substring(n2, n2 + n3).equals(string2)) {
                n2 += n3;
            }
            return string.substring(n2, n4);
        }
        return "";
    }

    protected static String gettokdn(String string, int n, String string2) {
        if (n == 0) {
            return "";
        }
        int n2 = 0;
        int n3 = string2.length();
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            if (i + n3 >= n4 || !string.substring(i, i + n3).equals(string2)) continue;
            if (++n2 == n) {
                return string.substring(0, i);
            }
            while (i + n3 < n4 && string.substring(i, i + n3).equals(string2)) {
                i += n3;
            }
        }
        return string;
    }

    public boolean isToken(String string) {
        return this.findToken(string) >= 0;
    }

    public int findToken(String string) {
        for (int i = 0; i < this.getTotalTokens(); ++i) {
            if (!this.getToken(i).toUpperCase().equals(string.toUpperCase())) continue;
            return i;
        }
        return -1;
    }
}

