/*
 * Decompiled with CFR 0.152.
 */
package sleep.console;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import sleep.console.ConsoleImplementation;
import sleep.console.ConsoleProxy;
import sleep.error.YourCodeSucksException;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;
import sleep.runtime.SleepUtils;
import sleep.taint.TaintUtils;

public class TextConsole
implements ConsoleProxy {
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] stringArray) {
        ScriptLoader scriptLoader = new ScriptLoader();
        ConsoleImplementation consoleImplementation = new ConsoleImplementation(null, null, scriptLoader);
        consoleImplementation.setProxy(new TextConsole());
        if (stringArray.length > 0) {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            for (n = 0; n < stringArray.length && (stringArray[n].startsWith("--") || stringArray[n].length() >= 2 && stringArray[n].charAt(0) == '-'); ++n) {
                if (stringArray[n].equals("-version") || stringArray[n].equals("--version") || stringArray[n].equals("-v")) {
                    System.out.println("Sleep 2.1 (20080807)");
                    return;
                }
                if (stringArray[n].equals("-help") || stringArray[n].equals("--help") || stringArray[n].equals("-h")) {
                    System.out.println("Sleep 2.1 (20080807)");
                    System.out.println("Usage: java [properties] -jar sleep.jar [options] [-|file|expression]");
                    System.out.println("       properties:");
                    System.out.println("         -Dsleep.assert=<true|false>");
                    System.out.println("         -Dsleep.classpath=<path to locate 3rd party jars from>");
                    System.out.println("         -Dsleep.debug=<debug level>");
                    System.out.println("         -Dsleep.taint=<true|false>");
                    System.out.println("       options:");
                    System.out.println("         -a --ast       display the abstract syntax tree of the specified script");
                    System.out.println("         -c --check     check the syntax of the specified file");
                    System.out.println("         -e --eval      evaluate a script as specified on command line");
                    System.out.println("         -h --help      display this help message");
                    System.out.println("         -p --profile   collect and display runtime profile statistics");
                    System.out.println("         -t --time      display total script runtime");
                    System.out.println("         -v --version   display version information");
                    System.out.println("         -x --expr      evaluate an expression as specified on the command line");
                    System.out.println("       file:");
                    System.out.println("         specify a '-' to read script from STDIN");
                    return;
                }
                if (stringArray[n].equals("--check") || stringArray[n].equals("-c")) {
                    bl = true;
                    continue;
                }
                if (stringArray[n].equals("--ast") || stringArray[n].equals("-a")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[n].equals("--profile") || stringArray[n].equals("-p")) {
                    bl5 = true;
                    continue;
                }
                if (stringArray[n].equals("--time") || stringArray[n].equals("-t")) {
                    bl6 = true;
                    continue;
                }
                if (stringArray[n].equals("--eval") || stringArray[n].equals("-e")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[n].equals("--expr") || stringArray[n].equals("-x")) {
                    bl4 = true;
                    continue;
                }
                System.err.println("Unknown argument: " + stringArray[n]);
                return;
            }
            Scalar scalar = SleepUtils.getArrayScalar();
            for (int i = n + 1; i < stringArray.length; ++i) {
                scalar.getArray().push(TaintUtils.taint(SleepUtils.getScalar(stringArray[i])));
            }
            try {
                ScriptInstance scriptInstance = bl3 ? scriptLoader.loadScript(stringArray[n - 1], stringArray[n], new Hashtable()) : (bl4 ? scriptLoader.loadScript(stringArray[n - 1], "println(" + stringArray[n] + ");", new Hashtable()) : (stringArray[n].equals("-") ? scriptLoader.loadScript("STDIN", System.in) : scriptLoader.loadScript(stringArray[n])));
                scriptInstance.getScriptVariables().putScalar("@ARGV", scalar);
                scriptInstance.getScriptVariables().putScalar("$__SCRIPT__", SleepUtils.getScalar(scriptInstance.getName()));
                if (System.getProperty("sleep.debug") != null) {
                    scriptInstance.setDebugFlags(Integer.parseInt(System.getProperty("sleep.debug")));
                }
                if (bl5) {
                    scriptInstance.setDebugFlags(scriptInstance.getDebugFlags() | 0x18);
                }
                if (bl) {
                    System.out.println(stringArray[n] + " syntax OK");
                } else if (bl2) {
                    System.out.println(scriptInstance.getRunnableBlock());
                } else {
                    long l = System.currentTimeMillis();
                    scriptInstance.runScript();
                    if (bl5) {
                        scriptInstance.printProfileStatistics(System.out);
                    }
                    if (bl6) {
                        long l2 = System.currentTimeMillis() - l;
                        System.out.println("time: " + (double)l2 / 1000.0 + "s");
                    }
                }
            }
            catch (YourCodeSucksException yourCodeSucksException) {
                consoleImplementation.processScriptErrors(yourCodeSucksException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                consoleImplementation.rppl();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void consolePrint(String string) {
        System.out.print(string);
    }

    public void consolePrintln(Object object) {
        System.out.println(object.toString());
    }

    public String consoleReadln() {
        try {
            return this.in.readLine();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

